/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/SetCmd.java,v 1.3 2005/12/25 03:45:39 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:39 $
 */
 
package com.sun.cli.jmx.cmd;


import com.sun.cli.jmx.support.ResultsForGetSet;
import com.sun.cli.jmx.support.CLISupportMBeanProxy;
import com.sun.cli.util.stringifier.*;

public class SetCmd extends GetSetCmd
{
		public
	SetCmd( final CmdEnv env )
	{
		super( env );
	}
	
		public String
	getUsage()
	{
		return( CmdStrings.SET_HELP.toString() );
	}
	
		public static String []
	getNames( )
	{
		return( new String [] { "set", "s" } );
	}
	
		void
	executeInternal()
		throws Exception
	{
		final String  attributes	= getAttributes();
		final String []	targets		= getTargets();
		
		establishProxy();
		final ResultsForGetSet []	results	= getProxy().mbeanSet( attributes, targets );
		println( ArrayStringifier.stringify( results, "\n\n" ) );
	}
}

