/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/AliasMgrTest.java,v 1.3 2005/12/25 03:45:44 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:44 $
 */
 

package com.sun.cli.jmx.support;

/*
	This MBean must be modified to store its aliases within domain.xml.  For now, it uses
	an internal implementation.
 */
public final class AliasMgrTest extends junit.framework.TestCase
{
		public
	AliasMgrTest(  )
	{
	}
	
		public void
	attemptInvalidName( String name )
	{
		try
		{
			create().createAlias( name, "bad name" );
			fail( "expected alias to fail: \"" + name + "\"");
		}
		catch( Exception e )
		{
			// good, we expected to get here
		}
	}
	
	public final static String	LEGAL_CHARS	=  "-_." +
			"0123456789" +
			"abcdefghijklmnopqrstuvwxyz" +
			"ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			
	public final static String	ILLEGAL_CHARS	= 
			"!@#$%^&*()+=" +
			"~`{}[]:;\"\'<>,?/" +
			"\n\r\t";

		AliasMgrMBean
	create( )
	{
		return( new AliasMgr( new AliasMgrHashMapImpl() ) );
	}
	
		public void
	testEmptyName()
		throws Exception
	{
		attemptInvalidName( "" );
	}
		public void
	testIllegalChars()
	{
		for( int i = 0; i < ILLEGAL_CHARS.length(); ++i )
		{
			final char	theChar	= ILLEGAL_CHARS.charAt( i );
			
			attemptInvalidName( "" + theChar );
			attemptInvalidName( "x" + theChar + "y" );
		}
	}
	
		public void
	testLegalChars()
		throws Exception
	{
		final AliasMgrMBean	aliasMgr	= create();
				
		aliasMgr.createAlias( LEGAL_CHARS, "test" );
			
		for( int i = 0; i < LEGAL_CHARS.length(); ++i )
		{
			final char	theChar	= LEGAL_CHARS.charAt( i );
			
			aliasMgr.createAlias( "" + theChar, "test" );
		}
	}
	
	
	final String 	TEST		= "test.";
	final String 	TEST_VALUE	= "test value";
	
		public void
	testLifecycle()
		throws Exception
	{
		final AliasMgrMBean	aliasMgr	= create();
		
		aliasMgr.createAlias( TEST, TEST_VALUE );
		assertEquals( TEST_VALUE, aliasMgr.resolveAlias( TEST ) );
		
		aliasMgr.deleteAlias( TEST );
		assertEquals( null, aliasMgr.resolveAlias( TEST ) );
	}
	
	
	
		public void
	testList()
		throws Exception
	{
		final AliasMgrMBean	aliasMgr	= create();
		assertEquals( 0, aliasMgr.listAliases( true ).length );
		assertEquals( 0, aliasMgr.getAliases( ).length );
		
		aliasMgr.createAlias( TEST, TEST_VALUE );
		assertEquals( 1, aliasMgr.listAliases( true ).length );
		assertEquals( 1, aliasMgr.listAliases( false ).length );
		assertEquals( 1, aliasMgr.getAliases( ).length );
		
		String	[]	listedAliases	= aliasMgr.listAliases( false );
		assertEquals( TEST, listedAliases[ 0 ] );
		
		listedAliases	= aliasMgr.listAliases( true );
		assertEquals( TEST + "=" + TEST_VALUE , listedAliases[ 0 ] );
	}
}








