/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/util/InvokeHelper.java,v 1.3 2005/12/25 03:45:54 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:54 $
 */
 

package com.sun.cli.jmx.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import com.sun.cli.util.ClassUtil;



public class InvokeHelper
{
	final Object	mTarget;
	
		public 
	InvokeHelper( Object target )
	{
		mTarget	= target;
	}
	
		static public Class []
	StringsToClasses( String [] signature )
		throws ClassNotFoundException
	{
		final int	count	= Array.getLength( signature );
		
		Class []	classes	 = new Class [ count ];
		
		for( int i = 0; i < count; ++i )
		{
			classes[ i ]	= ClassUtil.getClassFromName( signature[ i ] );
		}
		
		return( classes );
	}
	
        public Object
    invoke(
    	String	name,
    	Object	params[],
    	String	signature[] )
    	throws NoSuchMethodException, ClassNotFoundException,
    			InvocationTargetException, IllegalAccessException
    {
    	Object	result	= null;
    	
    	final Class []	signatureClasses	= StringsToClasses( signature );
    	
    	final Method	method	= mTarget.getClass().getDeclaredMethod( name, signatureClasses );
    	
    	result	= method.invoke( mTarget, params );
    	
    	return( result );
    }
}


