/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/StringifierRegistry.java,v 1.3 2005/12/25 03:46:09 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:09 $
 */
 
package com.sun.cli.util.stringifier;

import java.util.HashMap;
import java.util.Iterator;

import javax.management.*;

/*
	Holds a lookup table for Stringifiers.   Certain Stringifier classes
	may use this registry to aid them in producing suitable output.
 */
public class StringifierRegistry
{
	public static StringifierRegistry	DEFAULT	= new StringifierRegistry();
	
	private final HashMap						mLookup;
	private final StringifierRegistry			mNextRegistry;
	
	/*
		Create a new registry.  Use the DEFAULT registry if possible;
		certain Stringifier classes depend on it.
	 */
		public
	StringifierRegistry(  )
	{
		this( null );
	}
	
		public
	StringifierRegistry( StringifierRegistry registry )
	{
		mLookup			= new HashMap( );
		mNextRegistry	= registry;
	}
	
	/*
		Add a mapping from a Class to a Stringifier
		
		@param theClass	the Class to which the Stringifier should be associated
		@param stringifier	the Stringifier for the class
	 */
		public void
	add( Class theClass, Stringifier stringifier )
	{
		mLookup.remove( theClass );
		mLookup.put( theClass, stringifier );
	}
	
	
	/*
		Lookup a Stringifier from a Class.
		
		@param theClass	the Class
		@returns the Stringifier, or null if not found
	 */
		public Stringifier
	lookup( Class theClass )
	{
		Stringifier		stringifier	= (Stringifier)mLookup.get( theClass );
		
		if ( stringifier == null && mNextRegistry != null )
		{
		System.out.println( "can't find " + theClass.getName() );
			stringifier	= mNextRegistry.lookup( theClass );
		}
		
		return( stringifier );
	}
}



