/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.base.Util;
import javax.management.MalformedObjectNameException;
import java.lang.NullPointerException;
import javax.management.RuntimeOperationsException;

import java.util.Map;
import java.util.Set;
import java.util.Iterator;
import java.lang.IllegalArgumentException;
import java.io.File;
import java.io.IOException;



/**
 *  @version  $Revision: 1.3 $
 */
public class AMXDeleteResourceCommand extends S1ASCommand
{
    public final static String DOMAIN_CONFIG_OBJECT_NAME = "amx:j2eeType=X-DomainConfig,name=na";
    public final static String SERVER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-StandaloneServerConfig,name=";
    public final static String CLUSTER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-ClusterConfig,name=";
    public final static String TARGET_NAME = "target";

    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
    	return super.validateOptions();
    }
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation is false");
        
        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        final String targetName = (String)getOption(TARGET_NAME);
        
        //if targetName is not null, then try to get the Config ObjectName of the
        //target before deleting the resource because we don't want to delete
        //the resource if the target does not exist.
        ObjectName scON = (targetName!=null && !targetName.equals(DOMAIN))?
                          getTargetConfigObjectName(mbsc, targetName):null;

        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();
        
        try {
            if (scON!=null)
            {
                //remove reference to the target
                mbsc.invoke(scON, "removeResourceRefConfig",
                            new Object[]{new String((String)getOperands().get(0))},
                            new String[]{"java.lang.String"} );
                        
            }
            Object returnValue = mbsc.invoke(Util.newObjectName(DOMAIN_CONFIG_OBJECT_NAME),
                                             operationName,
                                             params, types);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful",
                                                       new Object[] {name}));
        }
        catch (Exception e) {
            displayExceptionMessage(e);
        }


    }

    
        /**
         * This routine will display the exception message if the option
         * --terse is given.  This routine will get the root of the exception
         * and display the message.  It will then wrap it with CommaneException
         * and throw the exception to be handled by CLI framework.
         * @param e
         * @throws CommandException
         */
    public void displayExceptionMessage(Exception e) throws CommandException
    {
            //get the root cause of the exception

        Throwable rootException = ExceptionUtil.getRootCause(e);

        if (rootException.getLocalizedMessage() != null)
            CLILogger.getInstance().printDetailMessage(rootException.getLocalizedMessage());
        throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                      new Object[] {name} ), e);

    }



        /**
         *  This routine will get the StandaloneServerConfig or ClusterConfig
         *  by the given target name.
         *  @param MBeanServerConnection
         *  @param targetName
         *  @return ObjectName
         */
    private ObjectName getTargetConfigObjectName(final MBeanServerConnection mbsc,
                                                 final String targetName)
        throws CommandException
    {

        try {
            ObjectName scON = Util.newObjectName(SERVER_CONFIG_OBJECT_NAME+targetName);
            if (!mbsc.isRegistered(scON))
                scON = Util.newObjectName(CLUSTER_CONFIG_OBJECT_NAME+targetName);
            if (!mbsc.isRegistered(scON))
                throw new CommandException(getLocalizedString("InvalidTargetName"));
        
            return scON;            
        }
        catch (RuntimeOperationsException roe)
        {
            throw new CommandException(roe);
        }
        catch (IOException ioe)
        {
            throw new CommandException(ioe);
        }
    }

}
