/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

/**
   This class gets called when change-admin-password command is invoked.
   This class will overwrite validOptions in GenericCommand to validate
   the userpassword option.  If the userpassword and passwordfile options
   are not entered in the command line and interactive is true, then
   CLI will prompt the user for the password.
 */
public class ChangeAdminPasswordCommand extends GenericCommand
{
    private static final String ADMIN_PASSWORD = "adminpassword";
    private static final String PASSWORD = "password";
    private static final String INTERACTIVE = "interactive";
    private static final String OLD_ADMIN_PASSWORD = "oldadminpassword";
    private static final String NEW_ADMIN_PASSWORD = "newadminpassword";
    private String sPassword;
    
    private String getOldAdminPassword() 
        throws CommandValidationException, CommandException
    {
        return getPassword(OLD_ADMIN_PASSWORD, 
            "OldAdminPasswordPrompt", null, 
            false, false, false, false, null, null, 
            true, false, true, false);
    }

    
    private String getNewAdminPassword() 
        throws CommandValidationException, CommandException
    {
        return getPassword(NEW_ADMIN_PASSWORD, 
            "NewAdminPasswordPrompt", "NewAdminPasswordConfirmationPrompt", 
            false, false, false, false, null, null, 
            true, true, true, false);
    }

    
    /**
       This method prompts the user for the old and new adminpassword.
     */    
    public boolean validateOptions() throws CommandValidationException
    {
    	super.validateOptions();
        
        try {
            /**
             * set interactive to true so that passwords can be prompted.
             **/
            setOption(INTERACTIVE, "true");
            //sPassword = getPassword("old " + ADMIN_PASSWORD, true, false, false, false, null, null, true, false, false, false);
            sPassword = getOldAdminPassword();
            setOption(PASSWORD, sPassword);
            //final String adminPassword = getPassword("new " + ADMIN_PASSWORD, true, false, false, false, null, null, true, true, false, false);
            final String adminPassword = getNewAdminPassword();
            setOption(ADMIN_PASSWORD, adminPassword);
        }
        catch (CommandException ce) {
            throw new CommandValidationException(ce.getLocalizedMessage());
        }                
        
        return true;
    }

        /**
         *  This is a polymorphic method that overwrites the one in S1ASCommand
         *  class.
         *  The reason for doing this is so that when GenericCommand class
         *  calls getPassword() in runCommand() routine, the warning message
         *  does not get displayed.
         **/
    public String getPassword() throws CommandValidationException, CommandException
    {
        return sPassword;
    }
    
}
