/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *  $Id: ChangeMasterPasswordCommand.java,v 1.3 2005/12/25 03:46:20 tcfujii Exp $
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;


import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.DomainException;


/**
 *  This is a local command that creates a new domain
 *  @version  $Revision: 1.3 $
 */
public class ChangeMasterPasswordCommand extends BaseLifeCycleCommand
{            
    private String newMasterPassword = null;
    private String masterPassword = null;

    /** Creates new CreateDomainCommand */
    public ChangeMasterPasswordCommand()
    {
    }

    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  @return true if successfull
     */
    public boolean validateOptions() throws CommandValidationException
    {
        super.validateOptions();

        //verify adminpassword is greater than 8 characters	
        if (!isPasswordValid(newMasterPassword)) {
            throw new CommandValidationException(getLocalizedString("PasswordLimit",
                new Object[]{NEW_MASTER_PASSWORD}));
        }
                
        return true;
    }

    public void changeMasterPassword(String domainName) 
        throws DomainException, CommandValidationException, CommandException
    {        
        //WARNING!!! The code below is duplicated in admin-cli-ee ChangeMasterPasswordCommand.java.
        //I tried to share the code but ran into issues.
        DomainConfig config = getDomainConfig(domainName);                         
        DomainsManager mgr = getFeatureFactory().getDomainsManager();    
        //domain validation upfront (i.e. before we prompt)                      
        mgr.validateDomain(config, true);
        
        masterPassword = getMasterPassword(new RepositoryManager(), config);
        //getPassword(optionName, allowedOnCommandLine, readPrefsFile, readPasswordOptionFromPrefs, 
        //readMasterPasswordFile, mgr, config,
        //promptUser, confirm, validate)
        config.put(DomainConfig.K_MASTER_PASSWORD, masterPassword);
        mgr.validateMasterPassword(config);
        
        newMasterPassword = getNewMasterPassword();
        validateOptions();            
        Boolean saveMasterPassword = getSaveMasterPassword(null);        
        config.put(DomainConfig.K_NEW_MASTER_PASSWORD, newMasterPassword);
        config.put(DomainConfig.K_SAVE_MASTER_PASSWORD, saveMasterPassword);
        mgr.changeMasterPassword(config);        
        //END WARNING!!!
    }
   
    /**
     *  An abstract method that executes the command
     *  @throws CommandException
     */
    public void runCommand() 
        throws CommandException, CommandValidationException
    {        
        String domainName = null;
        try {                 
            setLoggerLevel();
            domainName = getDomainName();
            changeMasterPassword(domainName);
            CLILogger.getInstance().printDetailMessage(getLocalizedString("DomainPasswordChanged",
                new Object[] {domainName})); 
        } catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());                        
            throw new CommandException(getLocalizedString("ExceptionChangingPassword", 
                                                          new Object[] {domainName}), e);            
        }
    }
}