/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;
import java.sql.*;
import java.io.File;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.cli.framework.CLILogger;

/**
 *  This class will created a dummy database called testconnectivity.
 *  and handshake with the database to get the Client Driver info.
 *  @author <a href="mailto:jane.young@sun.com">Jane Young</a> 
 *  @version  $Revision: 1.1 $
 */
public class DatabaseReporter {
    private static final StringManager lsm = StringManager.getManager(DatabaseReporter.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String DERBY_CLIENT_DRIVER_CLASS_NAME = "org.apache.derby.jdbc.ClientDriver";
    private static final String URL = "jdbc:derby://localhost:";
    private static final String DB_NAME = "/testconnectivity;create=true";
    private static final String USER = "APP";
    private static final String PASS = "APP";
    private static final String DB_PORT = "1527";
    private static final String DB_HOME = System.getProperty("user.dir");
    final private String dcn, url, user, password, dbhome, dbport;
    final private Connection conn;

        //constructor
    public DatabaseReporter( final String dbhome, final String dbport, final String dcn,
                             final String url, final String user, final String password) throws Exception {
	    this.dcn = dcn;
    	this.user = user;
    	this.password = password;
        this.dbhome = dbhome;
        this.dbport = dbport;
        this.url = url+dbport+DB_NAME;
    	Class.forName(dcn);
    	conn = DriverManager.getConnection(this.url, this.user, this.password);
    }

        /**
         * display the database info.
         */
    private void display() throws Exception
    {
        logger.printMessage(getDatabaseInfoMsg());
        logger.printMessage(getDatabaseDriverNameMsg());
        logger.printMessage(getDatabaseDriverVersionMsg());
        logger.printMessage(getJDBCSpecificationMsg());
    }

        /**
         * get database info msg.
         */
    private String getDatabaseInfoMsg()
    {
        return (lsm.getString("database.info.msg"));
    }
    
        /**
         * get database driver name.
         */
    private String getDatabaseDriverNameMsg() throws SQLException
    {
        final String sDriverName = conn.getMetaData().getDriverName();
        return ( lsm.getString("database.driver.name.msg", sDriverName));
    }

        /**
         * get database driver version.
         */
    private String getDatabaseDriverVersionMsg() throws SQLException
    {
        final String sDriverVersion = conn.getMetaData().getDriverVersion();
        return ( lsm.getString("database.driver.version.msg", sDriverVersion));
    }

        /**
         * get jdbc major and minor version.
         */
    private String getJDBCSpecificationMsg() throws SQLException
    {
        final int iJDBCMajorVersion = conn.getMetaData().getJDBCMajorVersion();
        final int iJDBCMinorVersion = conn.getMetaData().getJDBCMinorVersion();
        final String sJDBCSpec = iJDBCMajorVersion + "." + iJDBCMinorVersion;
        return ( lsm.getString("jdbc.version.msg", sJDBCSpec));
    }

        /**
         *  remove database file
         */
    private void removeDatabaseFile()
    {
		File f = new File(dbhome, "testconnectivity");
		FileUtils.whack(f);
    }
    
    

    public static void main(final String[] args) throws Exception {
	    DatabaseReporter dmt = null;
    	if (args == null || (args.length < 6 && args.length>2) ) {
	        dmt = new DatabaseReporter(DB_HOME, DB_PORT, DERBY_CLIENT_DRIVER_CLASS_NAME, URL, USER, PASS);
    	}
        else if (args.length == 2) {
	        dmt = new DatabaseReporter(args[0], args[1], DERBY_CLIENT_DRIVER_CLASS_NAME, URL, USER, PASS);
        }
    	else {
	        dmt = new DatabaseReporter(args[0], args[1], args[2], args[3], args[4], args[5]);
    	}
        try {
            dmt.display();
            dmt.removeDatabaseFile();
        }
        catch (Exception e) {
            logger.printMessage(lsm.getString("UnableToConnectToDatabase"));
            System.exit(1);
        }
        
    }
} 
