/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import java.util.Vector;
import javax.naming.NameClassPair;
import java.util.Iterator;
import java.util.ArrayList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;


public class ListJNDIEntriesCommand extends GenericCommand
{

    private static final String CONTEXT_OPTION = "context";

    public void displayExceptionMessage(Exception e) throws CommandException
    {
        Throwable t = e.getCause();
   
         if(t != null)
             CLILogger.getInstance().printDetailMessage(t.getMessage());
         else if(e != null)
             CLILogger.getInstance().printDetailMessage(e.getMessage()); 
		
         throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                       new Object[] {name} ), e);
    }


    protected void handleReturnValue(Object retVal)
    {
        final ArrayList list  =(ArrayList)retVal;

        if (!list.isEmpty())
        {
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "JndiEntries", new Object[]
                                                       {(String) getOperands().get(0),
                                                       getOption(CONTEXT_OPTION)==null?
                                                       "root":getOption(CONTEXT_OPTION)}) );
            
            final Iterator iterator= list.iterator();
            while (iterator.hasNext())
            {
                final NameClassPair nameClassPair = (NameClassPair) iterator.next();
            
                CLILogger.getInstance().printMessage(getLocalizedString("NameClassPair",                                                      new Object[]{nameClassPair.getName(), nameClassPair.getClassName()}));
            }
        }
    }
}
