/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.jmx;

import java.util.Set;
import java.util.IdentityHashMap;

import javax.management.*;
import com.sun.jmx.mbeanserver.SunJmxMBeanServer;
import com.sun.jmx.interceptor.ForwardingMBeanServerInterceptor;
import java.io.IOException;

/**
 * <p>An {@link MBeanServerInterceptor} that forwards every request
 * unchanged to another {@link MBeanServerInterceptor}.  This class is
 * useful as a superclass for interceptors that override some its
 * methods and perform some action before forwarding to the chained
 * interceptor.  Subclasses forward methods such as {@link
 * #getAttribute} by calling <code>super.getAttribute(...)</code>.
 * They may of course choose not to forward if appropriate.</p>
 *
 * <p>Any number of <code>ForwardingMBeanServerInterceptor</code>
 * objects may be chained together on the path from the MBean server
 * to its default {@link MBeanServerInterceptor}.  This class provides
 * convenience methods to manipulate such a chain.</p>
 *
 * <p>The same <code>ForwardingMBeanServerInterceptor</code> instance
 * should not be inserted into more than one MBean server at a
 * time.</p>
 */
public final class AppServerMBeanServerInterceptor extends ForwardingMBeanServerInterceptor {
    /**
     * <p>Create a new <code>ForwardingMBeanServerInterceptor</code>
     * that initially forwards its requests to nobody.  {@link
     * #setNextInterceptor} should be called before the interceptor is
     * inserted into an MBean server.  Otherwise, {@link
     * NullPointerException} will be produced for every operation on
     * that MBean server.</p>
     */
    protected AppServerMBeanServerInterceptor() {
    }

    public ObjectInstance createMBean(String className, ObjectName name,
				      Object params[], String signature[]) 
	    throws ReflectionException, InstanceAlreadyExistsException,
	    	   MBeanRegistrationException, MBeanException,
		   NotCompliantMBeanException {
                       System.out.println("AppServerMBeanServerInterceptor: createMBean");
	return super.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name,
				      ObjectName loaderName, Object params[],
				      String signature[]) 
	    throws ReflectionException, InstanceAlreadyExistsException,
	    	   MBeanRegistrationException, MBeanException,
	    	   NotCompliantMBeanException, InstanceNotFoundException {
                       System.out.println("AppServerMBeanServerInterceptor: createMBean");
	return super.createMBean(className, name, loaderName, params,
				signature);
    }
    
     public ObjectInstance createMBean(String className, ObjectName name,
				      ObjectName loaderName) 
	    throws ReflectionException, InstanceAlreadyExistsException,
		   MBeanRegistrationException, MBeanException,
		   NotCompliantMBeanException, InstanceNotFoundException,
		   IOException {
                       System.out.println("NYI: createMBean");
                       return null;
                       //FIXME: NYI??
     }

     public ObjectInstance createMBean(String className, ObjectName name)
	    throws ReflectionException, InstanceAlreadyExistsException,
		   MBeanRegistrationException, MBeanException,
		   NotCompliantMBeanException, IOException {
                       System.out.println("NYI: createMBean");
                   return null;
                   //FXIME: NYI??
     }
         
    public ObjectInstance registerMBean(Object object, ObjectName name)
	    throws InstanceAlreadyExistsException, MBeanRegistrationException,
		   NotCompliantMBeanException {
                       System.out.println("AppServerMBeanServerInterceptor: registerMBean");
	return super.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name)
	    throws InstanceNotFoundException, MBeanRegistrationException {
	super.unregisterMBean(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
	return super.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
	return super.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
	return super.isRegistered(name);
    }

    public Object getAttribute(ObjectName name, String attribute)
	    throws MBeanException, AttributeNotFoundException,
	    	   InstanceNotFoundException, ReflectionException {
        System.out.println("AppServerMBeanServerInterceptor: getAttrbute");
        MBeanManufacturer.findPersistent(name);
	return super.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes)
	    throws InstanceNotFoundException, ReflectionException {
                MBeanManufacturer.findPersistent(name);
	return super.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute)
	    throws InstanceNotFoundException, AttributeNotFoundException,
		   InvalidAttributeValueException, MBeanException, 
		   ReflectionException {
                       MBeanManufacturer.findPersistent(name);
	super.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name,
				       AttributeList attributes)
	    throws InstanceNotFoundException, ReflectionException {
	return super.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName,
			 Object params[], String signature[])
	    throws InstanceNotFoundException, MBeanException,
		   ReflectionException {
                       MBeanManufacturer.findPersistent(name);
	return super.invoke(name, operationName, params, signature);
    }
 
    public String getDefaultDomain() {
	return super.getDefaultDomain();
    }

    public MBeanInfo getMBeanInfo(ObjectName name)
	    throws InstanceNotFoundException, IntrospectionException,
	    	   ReflectionException {
        MBeanManufacturer.findPersistent(name);
        
	return super.getMBeanInfo(name);
    }

    public boolean isInstanceOf(ObjectName name, String className)
	    throws InstanceNotFoundException {
                System.out.println("isInstanceOF: ?? FIXME");
	return super.isInstanceOf(name, className);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName)
	throws InstanceNotFoundException {
	return super.getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName)
	throws InstanceNotFoundException {
	return super.getClassLoader(loaderName);
    }

    //FIXME: NYI!
    private String mapName(String name) {
        //replace dashes with underscores.
        return name.replace('-', '_');
    }
}
