/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/base/Attic/AllTypesMapper.java,v 1.4 2006/03/09 20:30:20 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:20 $
 */
 
package com.sun.appserv.management.base;

import com.sun.appserv.management.j2ee.J2EETypesMapper;


/**
	Map all types (XTypes and J2EETypes) to their respective interfaces.
	
	@see XTypesMapper
	@see com.sun.appserv.management.j2ee.J2EETypesMapper
 */
public final class AllTypesMapper extends TypesMapper
{
	private static AllTypesMapper	INSTANCE	= null;
	
	
	/**
		Get the singleton instance.
	 */
		public static synchronized AllTypesMapper
	getInstance()
	{
		if ( INSTANCE == null )
		{
			INSTANCE	= new AllTypesMapper();
		}
		
		return( INSTANCE );
	}

		private
	AllTypesMapper()
	{
		super( new Class[ 0 ] );
	}
	
	
	/**
		@param type the j2eeType
		@return the interface class associated with a given j2eeType.
	 */
		public Class<?>
	getInterfaceForType( final String type )
	{
		Class<?> theClass	= XTypesMapper.getInstance().getInterfaceForType( type );
		 
		if ( theClass == null )
		{
			theClass	= J2EETypesMapper.getInstance().getInterfaceForType( type );
		}

		if ( theClass == null )
		{
			throw new IllegalArgumentException( "Can't find interface for: " + type );
		}
		
		assert( AMX.class.isAssignableFrom( theClass ) ):
			"WARNING: mbean does not implement AMX: " + theClass.getName();

		return( theClass );
	}
	
	
}
