/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import com.sun.appserv.management.base.XTypes;

/**
	Programmatic access to dotted-names corresponding to <i>asadmin</i> CLI
	functionality.
	<p>
	Note that the set of dotted names is periodically refreshed; to force
	an update use {@link #refresh}.
	
	@see DottedNames
	@see AllDottedNames
	@see com.sun.appserv.management.config.ConfigDottedNames
	@see com.sun.appserv.management.monitor.MonitoringDottedNames
 */
public interface DottedNames extends AMX
{
	/**
		Return an array of values corresponding to each dotted-name.
		Each slot in the array will contain either an Attribute or an Exception.
	 */
	public Object[]	dottedNameGet( String[] names );
	
	/**
		Return a value for a dotted-name.  If a name does not exist,
		then null is returned.
		@param name
	 */
	public Object	dottedNameGet( String name );
	
	/**
		List all valid prefixes for dotted names
		@param names
	 */
	public Object[]	dottedNameList( String[] names );
	
	
	/**
		Set values for dotted names; each entry must be of the form:
		<pre>
            <i>dotted-name</i>=<i>value</i>
        </pre> 
		@param nameValuePairs
	 */
	public Object[]	dottedNameSet( String[] nameValuePairs );
	
	/**
		Force a refresh of the list of dotted names.
	 */
	public void	refresh();



}
