/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/client/Attic/AdminRMISSLClientSocketFactoryEnvImpl.java,v 1.4 2006/03/09 20:30:21 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:21 $
 */
package com.sun.appserv.management.client;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.net.ssl.HandshakeCompletedListener;

/**
	<b>Not for public use</b>
	<p>
	Class which encapsulates knowledge of how to exchange data between the
	RMISSLClientSocketFactory stub and the JVM into which it gets downloaded.
	<p>
	The client code configures this class so the RMI client stub may obtain
	any environmental overrides, thus enabling the client to control how the RMI
	stub behaves.
	<p>
	This class is global for all outgoing connections for RMI.
 */
public final class AdminRMISSLClientSocketFactoryEnvImpl // do NOT implement Serializable
	implements AdminRMISSLClientSocketFactoryEnv
{
	private static AdminRMISSLClientSocketFactoryEnvImpl	INSTANCE	= null;
	
	private transient TrustManager[]	mTrustManagers	= null;
	private transient HandshakeCompletedListener	mHandshakeCompletedListener	= null;
	
	private transient boolean			mTrace	= false;
	
	// for future extensions
	private transient Map<String,Object>				mValues;
	
	
		public static synchronized AdminRMISSLClientSocketFactoryEnvImpl
	getInstance()
	{
		// these should only ever be a single instance
		if ( INSTANCE == null )
		{
			INSTANCE	= new AdminRMISSLClientSocketFactoryEnvImpl();
		}
		return( INSTANCE );
	}

    	private
    AdminRMISSLClientSocketFactoryEnvImpl( )
    {
    	// important for server side to have these in place, or they
    	// will look for a truststore
    	mTrustManagers	= new TrustManager[0];
    	
    	mValues		= new HashMap<String,Object>();
    }
    
    
    	public Object
    getValue( final String key )
    {
    	return( mValues.get( key ) );
    }
    
    /**
    	No values are currently supported; this routine exists
    	for future extensions.
    	
    	@param key
    	@param value
     */
    	public Object
    setValue( final String key, final Object value )
    {
    	return( mValues.put( key, value ) );
    }
    
    /**
    	Set the TrustManagers.  Removes any existing trust-store and trust-store password
    	as the TrustManagers will be used instead.
    	
    	@param trustManagers
     */
    	public void
    setTrustManagers( final TrustManager[] trustManagers )
    {
    	mTrustManagers		= trustManagers;
    }

     	public TrustManager[]
    getTrustManagers( )
    {
    	return( mTrustManagers );
    }
 
    /**
    	Set a HandshakeCompletedListener (optional).
    	
    	@param listener
     */
    	public void
    setHandshakeCompletedListener( final HandshakeCompletedListener listener )
    {
    	mHandshakeCompletedListener	= listener;
    }
    
    	public HandshakeCompletedListener
    getHandshakeCompletedListener( )
    {
    	return( mHandshakeCompletedListener );
    }
    
    /**
    	Set tracing on or off.
    	
    	@param trace
     */
    	public void
    setTrace( final boolean trace )
    {
    	mTrace	= trace;
    }
    	public boolean
    getTrace()
    {
    	return( mTrace );
    }
	
}
