/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;




/**
	 Configuration for the &lt;auth-realm&gt; element.
*/

public interface AuthRealmConfig extends PropertiesAccess, NamedConfigElement 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.AUTH_REALM_CONFIG;
	
	
	/**
	    Classname of the default implementing class.
	 */
	public static final String DEFAULT_REALM_CLASSNAME  =
	    "com.sun.enterprise.security.auth.realm.file.FileRealm";
	    
	public static final String KEY_FILE_PROPERTY_KEY    = PropertiesAccess.PROPERTY_PREFIX + "file";
	
	public static final String JAAS_CONTEXT_PROPERTY_KEY    = PropertiesAccess.PROPERTY_PREFIX + "jaas-context";
	
	/**
	    When using {@link #DEFAULT_REALM_CLASSNAME} implementation, append
	    a file name to this prefix and specify it via {@link #KEY_FILE_PROPERTY_KEY}.
	 */
	public static final String KEY_FILE_PREFIX         = "${com.sun.aas.instanceRoot}/config/";
	
	
	public String	getClassname();
	public void	setClassname( String value );

    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public void			addUser( String user, String password, String[] groupList );
	
    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public String[]		getGroupNames();
	
    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public String[]		getUserGroupNames( String user );
	
    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public String[]		getUserNames();
	
    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public void			removeUser( String user );
	
    /**
        <b>Supported only for the default implementation ({@link #DEFAULT_REALM_CLASSNAME})</b>.
     */
	public void			updateUser( String user, String password, String[] groupList );





}
