/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.config;

import java.util.Map;


import javax.management.AttributeList;


import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;



/**
	 Configuration for an <http-listener&gt; element.
*/
public interface HTTPListenerConfig
	extends PropertiesAccess, NamedConfigElement, SSLConfigContainer, Enabled
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.HTTP_LISTENER_CONFIG;

	public String	getAcceptorThreads();
	public void		setAcceptorThreads( String value );

	public String	getAddress();
	public void		setAddress( String value );

	public String	getDefaultVirtualServer();
	public void		setDefaultVirtualServer( String value );

	public boolean	getEnabled();
	public void		setEnabled( boolean value );

	/**


		The port can be either a number or a system property ${...}, thus its
		type is String.
	 */
	public String	getPort();
	public void		setPort( String value );

	/**


		The port can be either a number or a system property ${...}, thus its
		type is String.
	 */
	public String	getRedirectPort();
	public void		setRedirectPort( String value );

	public boolean	getSecurityEnabled();
	public void		setSecurityEnabled( boolean value );

	public String	getServerName();
	public void		setServerName( String value );

	public boolean	getXpoweredBy();
	public void		setXpoweredBy( boolean value );

	/**
		See {@link HTTPListenerConfigFamilyValues}.
	*/
	public String	getFamily();
	/**
		@param value Valid values are as defined in {@link HTTPListenerConfigFamilyValues}.
	*/
	public void	setFamily( final String value );

	public String	getExternalPort();
	public void	setExternalPort( final String value );

	public boolean	getBlockingEnabled();
	public void	setBlockingEnabled( final boolean value );
}
