/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/HTTPProtocolConfigKeys.java,v 1.3 2005/12/25 03:49:31 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:31 $
 */
package com.sun.appserv.management.config;

/**
	Keys for use with {@link HTTPServiceConfig#createHTTPProtocolConfig}
	
	All Map values associated with a key are of class java.lang.String
	unless otherwise documented.
 */
public final class HTTPProtocolConfigKeys
{
	private	HTTPProtocolConfigKeys()	{}
	
	/** http version */
	public static final String VERSION_KEY				=	"Version";
	public static final String DNS_LOOKUP_ENABLED_KEY	=	"DNSLookupEnabled";
	
	/**
		See {@link HTTPProtocolConfig#setForcedResponseType} for legal values.
		The response type to be forced if the content served cannot   
        be matched by any of the MIME mappings for extensions.        
        Specified as a semi-colon delimited string consisting of      
        content-type, encoding, language, charset
        <p>
        Example: "text/html; charset=iso-8859-1"            
        
	 */
	public static final String FORCED_RESPONSE_TYPE_KEY		=	"ForcedResponseType";
	/**
		See {@link #FORCED_RESPONSE_TYPE_KEY}.
	 */
	public static final String DEFAULT_RESPONSE_TYPE_KEY	=	"DefaultResponseType";
	public static final String SSL_ENABLED_KEY				=	"SSLEnabled";
}