/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/JDBCConnectionPoolConfigKeys.java,v 1.3 2005/12/25 03:49:35 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:35 $
 */


package com.sun.appserv.management.config;


/**
	Keys for use with {@link DomainConfig#createJDBCConnectionPoolConfig}.
	
	@see IsolationValues
 */
public final class JDBCConnectionPoolConfigKeys
{
	private	JDBCConnectionPoolConfigKeys()	{}
	
	/**
		Key for use with {@link DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)}
		
		See {@link ConnectionValidationMethodValues}.
	*/
	public final static String	CONNECTION_VALIDATION_METHOD_KEY= "ConnectionValidationMethod";
	
	
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	VALIDATION_TABLE_NAME_KEY       = "ValidationTableName";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	DATASOURCE_CLASSNAME_KEY		= "DatasourceClassname";
	/** Key for use with {@link DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)}  */
	public final static String	FAIL_ALL_CONNECTIONS_KEY		= "FailAllConnections";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	IDLE_TIMEOUT_IN_SECONDS_KEY		= "IdleTimeoutInSeconds";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	IS_CONNECTION_VALIDATION_REQUIRED_KEY= "IsConnectionValidationRequired";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	IS_ISOLATION_LEVEL_GUARANTEED_KEY= "IsIsolationLevelGuaranteed";
	/**
		Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)}
		See {@link IsolationValues}.
	*/
	public final static String	TRANSACTION_ISOLATION_LEVEL_KEY= "TransactionIsolationLevel";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	MAX_POOL_SIZE_KEY				= "MaxPoolSize";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	MAX_WAIT_TIME_MILLIS_KEY		= "MaxWaitTimeInMillis";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	POOL_RESIZE_QUANTITY_KEY		= "PoolResizeQuantity";
	/**
		Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)}
		Possible values:
		<ul>
		<li>javax.sql.DataSource</li>
		<li>javax.sql.XADataSource</li>
		<li>javax.sql.ConnectionPoolDataSource</li>
		</ul>
	*/
	public final static String	RES_TYPE_KEY					= "ResType";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	STEADY_POOL_SIZE_KEY			= "SteadyPoolSize";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	DATABASE_NAME_KEY				= "property.DatabaseName";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	DATABASE_USER_KEY				= "property.User";
	/** Key for use with @link { DomainConfig#createJDBCConnectionPoolConfig(String, String, Map)} */
	public final static String	DATABASE_PASSWORD_KEY			= "property.Password";
	
	
}
