/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.io.File;

import java.lang.reflect.Constructor;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;



/**
	<b>Private interface, DO NOT USE</b>
*/
public final class OfflineConfigIniter 
{
    private final MBeanServer   mServer;
    private final File          mDomainXML;
    private final ObjectName    mLoader;
    private final DomainRoot    mDomainRoot;
    
    private static final String LOADER_CLASSNAME    =
        "com.sun.enterprise.management.offline.OfflineLoader";
    
    private final Class[]   LOADER_CONSTRUCTOR_SIG    = new Class[]
    {
        MBeanServer.class,
        File.class,
    };
    
        public
    OfflineConfigIniter(
        final MBeanServer server,
        final File        domainXML )
    {
        mServer     = server;
        mDomainXML  = domainXML;
        mLoader     = initLoader();
        
        mDomainRoot = ProxyFactory.getInstance( server ).getDomainRoot();
    }
    
        public DomainRoot
    getDomainRoot()
    {
        return mDomainRoot;
    }
    
    public static final String  NAME    = "offline-mbean-loader";
    
        private ObjectName
    initLoader()
    {
        ObjectName  loaderObjectName    = null;
        
        try
        {
            // can't import it because it's this code is in client API.
            // We want this feature to work only if the requisite classes are present,
            // but we can't include them.
            //
            final Class         loaderClass = Class.forName( LOADER_CLASSNAME );
            final Constructor   constructor =
                loaderClass.getConstructor( LOADER_CONSTRUCTOR_SIG );
            
            final Object    loader      = constructor.newInstance( mServer, mDomainXML );
            
            final String domain = AMX.JMX_DOMAIN + "-support";
            loaderObjectName  = Util.newObjectName( domain, Util.makeNameProp( NAME ) );
            loaderObjectName  =
                mServer.registerMBean( loader, loaderObjectName ).getObjectName();
        }
        catch(Throwable t)
        {
            t.printStackTrace();
            
            throw new RuntimeException( t );
        }
        
        return loaderObjectName;
    }
}

















