/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.Container;

/**
	An MBean implementing this interface can optionally contain an SSLConfig.
*/
public interface SSLConfigContainer extends Container 
{
	/**
	 * Creates a new SSLConfig.
	 *
	 * @param certNickName - the name of the server certificate in the
     * certificate database or the PCKS# 11 token
	 * @param optional optional values--see {@link SSLConfigKeys}
	 * @return A proxy to the SSLConfig MBean.
	 @see SSLConfigKeys
	 */
	public SSLConfig		createSSLConfig( String certNickName, Map<String,?> optional );

	/**
		Get the SSLConfig.
	 */
	public SSLConfig		getSSLConfig();

	/**
		Removes the SSLConfig.
	 */
	public void				removeSSLConfig();
}