/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.ext.logging;


/**
	Provides access to log files.
	
	@since AS 9.0
 */
public interface LogFileAccess
{
    /**
        Value meaning the most current version of the log file.
     */
    public static final String  MOST_RECENT_NAME = "MostRecentLogFileName";
     
	/**
		Key designating the server.log log files.
		<i>Not necessarily the same as the file name of the log file</i>.
	 */
    public static final String	SERVER_KEY	= "server";
    
	/**
		Key designating the access.log log file.
		<i>Not necessarily the same as the file name of the log file</i>.
	 */
    public static final String	ACCESS_KEY	= "access";
    
    /**
    	Keys which may be used to specify which log file to access.
    	Legal values include:
    	<ul>
    	<li>{@link #SERVER_KEY}</li>
    	<li>{@link #ACCESS_KEY} <b>is not supported</b></li>
    	</ul>
    	@return a String[] of the legal keys which designate log files
     */
    public String[]	getLogFileKeys();
    
    
	/**
		The names returned are <i>not</i> full paths but the simple file
		names of the log files.
		The last name in the resulting String[] will always be that of the
		current log file.  In other words if the String[] las length 3,
		then result[2] will be the name of the current log file.
		<p>
		Note that it is possible for log file rotation to occur after making
		this call, thus rendering the list incomplete.
		<p>
		The resulting names may be passed to {@link #getLogFile} to retrieve
		the contents.
		<p>
		The only legal key supported is {@link #SERVER_KEY}.
		
		@param key	a key specifying the type of log file
		@return String[] of all log filenames 
	 */
	public String[] getLogFileNames( final String key );
	
	/**
		The entire specified log file is read, converted into a String, and returned.
		The resulting String may be quite large.
		<p>
		The only legal key supported is {@link #SERVER_KEY}.
		
		@param key a legal key designating a log file
		@param fileName	a log file name as returned by {@link #getLogFileNames} or
		{@link #MOST_RECENT_NAME} if current log file is desired.
		@return the contents of the specified log file in a String
		@see #getLogFileKeys
	 */
	public String getLogFile( final String key, final String fileName );
	
    /**
		Rotate all log files as soon as possible.  May return
		prior to the rotation occuring.
     */
    public void rotateAllLogFiles();
    
    
    /**
    	Rotate the log file of the specified type.  Legal values are those
    	returned by {@link #getLogFileKeys}.
    	Legal values include:
    	<ul>
    	<li>{@link #SERVER_KEY}</li>
    	<li>{@link #ACCESS_KEY} <b>is not supported</b></li>
    	</ul>
    	@param key
     */
    public void rotateLogFile( String key );
}














