/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */

package com.sun.appserv.management.monitor;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.base.Container;

import com.sun.appserv.management.monitor.AMXStringMonitor;
import com.sun.appserv.management.monitor.AMXCounterMonitor;
import com.sun.appserv.management.monitor.AMXGaugeMonitor;


/**
	Supports the standard monitoring facilities of javax.management.monitor
	by making available routines to create the Monitors available in 
	javax.management.monitor, and to determine query which such Monitors
	are currently loaded.
	<p>
	Note that the naming is somewhat confusing; the use of the term "Monitor"
	here derives from javax.management.monitor; com.sun.appserv.monitor refers
	to MBeans that provide statistics on appserver runtime entities.
 */
public interface JMXMonitorMgr extends AMX, Singleton, Utility
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.JMX_MONITOR_MGR;
    
    /**
    	Create a new Monitor.
    	@param name
     */
    public AMXStringMonitor		createStringMonitor( final String name );
    
    /**
    	Create a new Monitor.
    	@param name
     */
    public AMXCounterMonitor		createCounterMonitor( final String name );
    
    /**
    	Create a new Monitor.
    	@param name
     */
    public AMXGaugeMonitor		createGaugeMonitor( final String name );
    
    
    /**
    	Return a Map of all AMXStringMonitor MBean.  The Map is keyed by name.
     */
    public Map<String,AMXStringMonitor> 		getStringMonitorMap();
    
    /**
    	Return a Map of all AMXCounterMonitor.  The Map is keyed by name.
     */
    public Map<String,AMXCounterMonitor> 		getCounterMonitorMap();
    
    /**
    	Return a Map of all AMXGaugeMonitor.  The Map is keyed by name.
     */
    public Map<String,AMXGaugeMonitor> 		getGaugeMonitorMap();

    
    /**
    	Remove a Monitor by name.
    	@param name
     */
    public void		remove( final String name );
}
