/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.appserv.management.monitor.statistics;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

/**
 * Stats interface for the monitorable attributes of a 
 * Load Balancer at the application level
 */
public interface LoadBalancerContextRootStats extends Stats {
    
    /** Returns  response time in milliseconds
     * @return an instance of {@link TimeStatistic}     
     */
    public TimeStatistic getResponseTime();

    /** Returns  average response time in milliseconds
     * @return an instance of {@link TimeStatistic}     
     */
    public CountStatistic getAverageResponseTime();
    
    /** Returns the number of failover requests
     * @return an instance of {@link CountStatistic}     
     */
    public CountStatistic getFailoverReqCount();
    
    /** Returns the number of error requests
     * @return an instance of {@link CountStatistic}     
     */
    public CountStatistic getErrorRequestCount();
    
    /** Returns the number of active requests
     * @return an instance of {@link CountStatistic}     
     */
    public CountStatistic getActiveRequestCount();

    /** Returns the number of total requests
     * @return an instance of {@link CountStatistic}     
     */
    public CountStatistic getTotalRequestCount();

    /** Returns the number of times all idempotent 
     * urls in this application are accessed
     * @return an instance of {@link CountStatistic}     
     */
    public CountStatistic getIdempotentUrlAccessCount();
}