/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.util.jmx;

import javax.management.MBeanAttributeInfo;

import com.sun.appserv.management.util.jmx.stringifier.MBeanAttributeInfoStringifier;
import com.sun.appserv.management.util.jmx.stringifier.MBeanFeatureInfoStringifierOptions;

/**
	Caution: this Comparator may be inconsistent with equals() because it ignores the description.
 */
public final class MBeanAttributeInfoComparator implements java.util.Comparator<MBeanAttributeInfo>
{
	private static final MBeanAttributeInfoStringifier		ATTRIBUTE_INFO_STRINGIFIER	=
		new MBeanAttributeInfoStringifier( new MBeanFeatureInfoStringifierOptions( false, ",") );
	
	public static final MBeanAttributeInfoComparator		INSTANCE	= new MBeanAttributeInfoComparator();
	
	private	MBeanAttributeInfoComparator()	{}
	
		public int
	compare( final MBeanAttributeInfo o1, final MBeanAttributeInfo o2 )
	{
		final String	s1	= ATTRIBUTE_INFO_STRINGIFIER.stringify( o1 );
		final String	s2	= ATTRIBUTE_INFO_STRINGIFIER.stringify( o2 );
		
		return( s1.compareTo( s2 ) );
	}
	
		public boolean
	equals( Object other )
	{
		return( other instanceof MBeanAttributeInfoComparator );
	}
}
	
	



