/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import java.util.Set;
import java.util.Iterator;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;


public class CompositeDataStringifier implements Stringifier
{
	public static final CompositeDataStringifier	DEFAULT	= new CompositeDataStringifier();
	
		public
	CompositeDataStringifier( )
	{
	}
	
		public String
	stringify( Object o )
	{
		final StringBuffer	buf	= new StringBuffer();
		buf.append( "Composite data:\n" );
		
		final CompositeData	data	= (CompositeData)o;
		final CompositeType	type	= data.getCompositeType();
		
		final Set		keySet	= type.keySet();
		final Iterator	iter	= keySet.iterator();
		while ( iter.hasNext() )
		{
			final String	key	= (String)iter.next();
			final Object	item	= data.get( key );
			
			final String	s	= SmartStringifier.toString( item );
			buf.append( key + "=" + s + "\n" );
		}
		
		return( buf.toString() );
	}
}



















