/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx.stringifier;

import java.lang.reflect.Array;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;

public class MBeanInfoStringifier extends MBeanFeatureInfoStringifier implements Stringifier
{
	public static final MBeanInfoStringifier	DEFAULT	= new MBeanInfoStringifier();
	
		public
	MBeanInfoStringifier()
	{
		super();
	}
	
		public
	MBeanInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		super( options );
	}
	
		private String
	stringifyArray( Object [] a, Stringifier stringifier)
	{
		String	temp	= "";
		
		if ( a.length != 0 )
		{
			temp	= "\n" + ArrayStringifier.stringify( a, "\n", stringifier);
		}
		return( temp );
	}
	
	// subclass may override
		MBeanAttributeInfoStringifier
	getMBeanAttributeInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanAttributeInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanOperationInfoStringifier
	getMBeanOperationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanOperationInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanConstructorInfoStringifier
	getMBeanConstructorInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanConstructorInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanNotificationInfoStringifier
	getMBeanNotificationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new MBeanNotificationInfoStringifier(options) );
	}
	
		public String
	stringify( Object o)
	{
		String			result	= "";
		final MBeanInfo	info	= (MBeanInfo)o;
		
		final MBeanOperationInfo []		operations		= info.getOperations();
		final MBeanAttributeInfo []		attributes		= info.getAttributes();
		final MBeanConstructorInfo []	constructors	= info.getConstructors();
		final MBeanNotificationInfo []	notifications	= info.getNotifications();
		final String    description = info.getDescription();
		
		result	= "Summary: " +
					operations.length + " operations, " +
					attributes.length + " attributes, " +
					constructors.length + " constructors, " +
					notifications.length + " notifications" +
					(description == null ? "" : ", \"" + description + "\"" );
		
		final MBeanFeatureInfoStringifierOptions options	=
				new MBeanFeatureInfoStringifierOptions( true, "," );
		
		// Do formal terms like "Attributes" need to be I18n?
		// Probabably not as they are part of a specification.
		result	= result + "\n\n- Attributes -" +
					stringifyArray( attributes, getMBeanAttributeInfoStringifier( options ) );
	
		result	= result + "\n\n- Operations -" +
					stringifyArray( operations, getMBeanOperationInfoStringifier(options) );
	
		result	= result + "\n\n- Constructors -" +
					stringifyArray( constructors, getMBeanConstructorInfoStringifier(options) );
	
		result	= result + "\n\n- Notifications -" + 
					stringifyArray( notifications, getMBeanNotificationInfoStringifier(options) );
		
		return( result );
			
	}
}





