/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/misc/Attic/Formatter.java,v 1.3 2005/12/25 03:51:46 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:46 $
 */
 
package com.sun.appserv.management.util.misc;


import java.text.MessageFormat;

import com.sun.appserv.management.util.misc.ClassUtil;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.appserv.management.util.stringifier.StringifierRegistry;
import com.sun.appserv.management.util.stringifier.StringifierRegistryImpl;

/**
	Escapes/unescapes strings
 */
public final class Formatter implements StringSource
{
	final StringSource			mStringSource;
	final StringifierRegistry	mRegistry;
	
		public
	Formatter( StringSource source )
	{
		mStringSource	= source;
		mRegistry		= StringifierRegistryImpl.DEFAULT;
	}
	
		public Object
	prepare( Object o )
	{
		Object	result	= o;
		
		if ( mRegistry.lookup( o.getClass() ) != null ||
			ClassUtil.objectIsArray( o ) )
		{
			result	= SmartStringifier.toString( o );
		}
		
		return( result );
	}
	
	/**
		Prepare objects for formatting. Certain objects are not properly handled by MesageFormat
		(such as Sets and arrays). We'll intercept these types, but leave dates and numbers
		to MessageFormat.
	 */
		private Object[]
	prepare( Object[] objects )
	{
		final Object[]	results	= new Object[ objects.length ];
		
		for( int i = 0; i < objects.length; ++i )
		{
			results[ i ]	= prepare( objects[ i ] );
		}
		
		return( results );
	}
	
	/**
		Format the objects into a String using the pattern specified by 'key'.
		
		@param key		key used to look up the pattern
		@param objects	array of objects to insert into the pattern
	 */
		public String
	format( String key, Object[] objects )
	{
		return( MessageFormat.format( getString( key ), prepare( objects ) ) );
	}
	
		public String
	format( String key, Object o1 )
	{
		return( format( key, new Object[] { o1 } ) );
	}
	
		public String
	format( String key, Object o1, Object o2)
	{
		return( format( key, new Object[] { o1, o2 } ) );
	}
	
		public String
	format( String key, Object o1, Object o2, Object o3)
	{
		return( format( key, new Object[] { o1, o2, o3} ) );
	}
	
		public String
	format( String key, Object o1, Object o2, Object o3, Object o4)
	{
		return( format( key, new Object[] { o1, o2, o3, o4 } ) );
	}
	
	
		public String
	getString( String id )
	{
		return( mStringSource.getString( id ) );
	}
	
		public String
	getString( String id, String defaultValue)
	{
		return( mStringSource.getString( id, defaultValue ) );
	}
}


