/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/* MutableTimeStatistic.java
 * $Id: MutableTimeStatistic.java,v 1.2 2005/12/25 03:52:20 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2005/12/25 03:52:20 $
 */


package com.sun.enterprise.admin.monitor.stats;

/**
 * Provides mutable nature to the {@link TimeStatistic}. Like other MutableStatistic
 * interfaces, it does have the state to calculate the specific statistical data
 * in {@link TimeStatistic}. Unlike other mutable statistics though, in this interface
 * there is some consideration of a sequence. Once an instance of this interface
 * is created, subsequent call to {@link #incrementCount} has a twofold effect:
 * <ul>
 *   <li> Increments the count for number of times the operation is executed by 1 </li>
 *   <li> Keeps a count of maximum/minimum/total execution time </li>
 * <ul>
 * @author  <a href="mailto:Kedar.Mhaswade@sun.com">Kedar Mhaswade</a>
 * @since S1AS8.0
 * @version $Revision: 1.2 $
 */
public interface MutableTimeStatistic extends MutableStatistic {
    
    /**
     * Increments the count for number of times an operation is called by 1 and 
     * processes the given parameter in a certain manner. 
     */
    public void incrementCount(long currentExecutionTimeMillis);
}
