/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: ServletStats.java,v 1.2 2005/12/25 03:52:24 tcfujii Exp $
 * $Date: 2005/12/25 03:52:24 $
 * $Revision: 1.2 $
 *
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

/** 
 * Defines additional Sun ONE Application Server specific statistics 
 * ServletStats interface.
 * The ServletStats interface that is defined by JSR77, cannot be used
 * here, as it is not possible to encapsulate the data pertaining to 
 * the service method in a TimeStatistic. Therefore it becomes necessary
 * to define our own interface for exposing Servlet Statistics.
 * @since S1AS8.0
 */
public interface ServletStats extends Stats {
    
    /**
     * Number of requests processed by this servlet.
     * @return CountStatistic
     */
    public CountStatistic getRequestCount();
    
    /**
     * Cumulative Value, indicating the time taken to process the
     * requests received so far.
     * @return CountStatistic
     */
    public CountStatistic getProcessingTime();
    
    /**
     * Gets the execution time of the servlet's service method.
     *
     * This method is identical in functionality to getProcessingTime(),
     * except that it exposes the execution time of the servlet's service
     * method under the JSR 77 compliant property name and type.
     *
     * @return Execution time of the servlet's service method
     */
    public TimeStatistic getServiceTime();

    /**
     * The maximum processing time of a servlet request
     * @return CountStatistic
     */
    public CountStatistic getMaxTime();
    
    /**
     * The errorCount represents the number of cases where the response 
     * code was >= 400
     * @return CountStatistic
     */
    public CountStatistic getErrorCount();
    
}
