/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * StatsToString.java
 * $Id: StatsToString.java,v 1.2 2005/12/25 03:52:33 tcfujii Exp $
 * $Date: 2005/12/25 03:52:33 $
 * $Revision: 1.2 $
 */


package com.sun.enterprise.admin.monitor.util;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;
/**
 * Returns String implementation of all the statistics within the {@link Stats}
 * instance passed in with one statistic per line.
 * @author  <a href="mailto:Kedar.Mhaswade@sun.com">Kedar Mhaswade</a>
 * @since __PRODUCT__
 * @version $Revision: 1.2 $
 */
public class StatsToString {
	private final Stats stats;
	private final String NL = System.getProperty("line.separator");
	/** Creates a new instance of StatsToString */
	StatsToString(Stats stats) {
		this.stats = stats;
	}
	public String toString() {
		final StringBuffer s = new StringBuffer(stats.getClass().getName()).append(NL);
		final Statistic[] ss = stats.getStatistics();
		for(int i = 0 ; i < ss.length ; i++) {
			s.append(ss[i].toString()).append(NL);
		}
		return s.toString();
	}
}
