/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FileUserHandler.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;


import java.util.EventObject;
import java.util.StringTokenizer;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModelImpl;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;

public class FileUserHandler {

    public boolean manageUsers(RequestContext ctx, HandlerContext handlerCtx) {
        DescriptorContainerView parent = (DescriptorContainerView) handlerCtx.getView().getParent();

	String classname = (String)handlerCtx.getInputValue("classname") ;
        if (classname == null) {
            if (Util.isLoggableFINER()) {
                Util.logFINER("The manageUsers 'classname' input variable was not specified. ("+
                    classname + ")");
            }
            return false;
        }
        Class realm = null;;
        try {
            realm = Class.forName(classname);
        } catch (ClassNotFoundException ex) {
            if (Util.isLoggableFINER()) {
                Util.logFINER("The FileRealm classname, "+classname+" was not found.");
            }
        }
        Class baseClass = null;;
        try {
            baseClass = Class.forName("com.sun.enterprise.security.auth.realm.IASRealm");
        } catch (ClassNotFoundException ex) {
            if (Util.isLoggableFINER()) {
                Util.logFINER("The class: " +
                "\"com.sun.enterprise.security.auth.realm.IASRealm\"" +
                " was not found.");
            }
        }
        if (realm == null || baseClass == null)
            return false;
        
        if (baseClass.isAssignableFrom(realm)) 
            return hasPropsForFileRealm(parent);
        
        if (Util.isLoggableFINER()) {
            Util.logFINER("The FileRealm classname, \"" + classname + 
                "\" does not extend \"com.sun.enterprise.security.auth.realm.IASRealm\".");
        }
        
	//if (classname != null && classname.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
	//    return true;
	//}
	return false;
    }
    
    private boolean hasPropsForFileRealm(DescriptorContainerView parent) {
        Object objectName = parent.getViewDescriptor().getParameter("objectName");
        if (objectName == null)
            return false;
        
        AttributeList props = (AttributeList)MBeanUtil.invoke(objectName.toString(), 
            "getProperties", null, null);
        if (props == null)
            return false;
        
        boolean jassContextFound = false;
        boolean fileRealmFound = false;

        for (int i = 0; i < props.size(); i++) {
            Attribute prop = (Attribute)props.get(i);
            String name = prop.getName();
            if (name.equals("jaas-context") && prop.getValue() != null)
                jassContextFound = true;
            if (name.equals("file") && prop.getValue() != null)
                fileRealmFound = true;
        }
        if (jassContextFound && fileRealmFound)
            return true;
        return false;
    }

    public void populateFileUsersModel(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
	    ViewDescriptor desc = (view instanceof DescriptorContainerView) ?
		((DescriptorContainerView)view).getViewDescriptor() :
		(ViewDescriptor)null;
	    throw new FrameworkException("This handler is for 'beforeCreate'" +
		" handlers only!", desc, view);
	}
	ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
	try {
            if (desc instanceof CCActionTableDescriptor) {
		CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
                load(ccDesc.getModel(), ctx, handlerCtx);
	    }
        } catch (Exception ex) {
            throw new FrameworkException(ex, desc, view);
        }
    }

    private void load(CCActionTableModelInterface model, 
                RequestContext ctx, HandlerContext handlerCtx) {
        Object[] userNames = (Object[])handlerCtx.getInputValue("userNames");
	String objectName   = (String)handlerCtx.getInputValue("objectName");
        if (userNames == null) {
            return; //nothing to load..
	}
        for (int rowNo = 0; rowNo < userNames.length; rowNo++) {
            model.appendRow();
	    //userId, and groupList fieldNames are defined in the xml file.
	    model.setValue(USER_ID, userNames[rowNo]);
	    String groupNames = getGroupNames((String)userNames[rowNo], objectName);
	    model.setValue(GROUP_LIST, groupNames);
        }
    }

    public void addOrUpdateFileUser(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
		throw new FrameworkException("view is not DescriptorContainerView.", null, view);
            }
            else {
                view = parent;
            }
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;

	String user = (String)descView.getDisplayFieldValue(USER_ID);
	String passwd = (String)descView.getDisplayFieldValue(PASSWORD);
	String groupList = (String)descView.getDisplayFieldValue(GROUP_LIST);
        
	String objectName = (String)handlerCtx.getInputValue("objectName");
	String methodName = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null || (methodName.equals("addUser") == false && 
            methodName.equals("updateUser") == false)) {
            throw new FrameworkException(
                "Illegal method name, must be \"addUser\" or \"updateUser\": " +
                methodName, descView.getViewDescriptor(), view);            
        }
        groupList = groupList.replaceAll(" ", "");
	String[] groups = getStringArray(groupList, ",");
        Object[] params = new Object[]{user, passwd, groups};
	String[] types = new String[]{"java.lang.String", 
                                      "java.lang.String", 
                                      groups.getClass().getName()};
	if (Util.isLoggableFINER()) {
            // Log some trace info
            StringBuffer buf = new StringBuffer();
            buf.append("USER NAME = "+user);
            buf.append(", PASSWORD = "+passwd);
            buf.append(", GROUP = "+groupList);
            buf.append(", OBJECTNAME = "+objectName);
            buf.append(", METHODNAME = "+methodName);
	    Util.logFINER(buf.toString());
	}

        try {
            Object object = MBeanUtil.invoke(objectName, methodName, params, types);
        } catch (Exception ex) {
            throw new FrameworkException(ex, descView.getViewDescriptor(), view);
        }
    }

    //can be an utility method
    private String[] getStringArray(String str, String delimiter) {
	if(str == null) {
	    return null;
	}
	StringTokenizer strToken = new StringTokenizer(str, delimiter);
	String[] strArray = new String[strToken.countTokens()];
	int i = 0;

	while(strToken.hasMoreTokens()) {
	    strArray[i++] = strToken.nextToken();
	}

	return strArray;
    }
    
    public void getUser(RequestContext ctx, HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("user", ctx.getRequest().getRemoteUser());
    }

    public void populateFileUsersDisplayFields(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
		throw new FrameworkException(
		    "view is not DescriptorContainerView", null, view);
            } else {
                view = parent;
            }
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }

        DescriptorContainerView descView = (DescriptorContainerView)view;
        
	String objectName = (String)handlerCtx.getInputValue("objectName");
	String userName   = (String)handlerCtx.getInputValue("userName");
	String groupNames = getGroupNames(userName, objectName);

        descView.setDisplayFieldValue(USER_ID, userName);
	descView.setDisplayFieldValue(GROUP_LIST, groupNames);
    }

    private String getGroupNames(String userName, String objectName) {
	String[] groupList = null;
	String groupNames = null;
	try {
	    Object obj = MBeanUtil.invoke(objectName, GETUSER_GROUPNAME, 
                new Object[]{userName}, new String[]{"java.lang.String"});
            groupList = (String[])obj;
        } catch (Exception ex) {
	    throw new FrameworkException(ex);
        }
	if(groupList != null && groupList.length > 0) {
	    groupNames = groupList[0];
	    for (int i = 1; i < groupList.length; i++) {
		groupNames += ","+groupList[i];
	    }
	}
	return groupNames;
    }


    public void deleteFileUser(RequestContext ctx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)
	    (((ViewBase)view).getParentViewBean());
	ViewDescriptor vd = descView.getViewDescriptor();
	String childName = (String)vd.getParameter("tableChildName");

	if (childName == null) {
	    throw new FrameworkException("tableChildName not specified", vd, view);
	}
	ViewDescriptor tableDesc = vd.getChildDescriptor(childName);
	if (tableDesc == null) {
	    throw new FrameworkException("tableDescriptor is null", vd, view);
	}
	if (!(tableDesc instanceof CCActionTableDescriptor)) {
	    throw new FrameworkException("tableDescriptor is of wrong type",
		tableDesc, view);
	}
        CCActionTableModelInterface model = 
            ((CCActionTableDescriptor)tableDesc).getModel();

        String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
	String objectName = (String)handlerCtx.getInputValue("objectName");

	if (deleteKey == null) {
	    throw new FrameworkException("No delete key specified", tableDesc, null);
	}
	if (objectName == null) {
	    throw new FrameworkException("No ObjectName  specified", tableDesc, null);
	}

	model.setRowSelectionType("multiple");
	try {
	    model.beforeFirst();
	    // from the model, get the child that has the needed value...
	    while (model.next()) {
		if (model.isRowSelected()) {
		    Object[] params;
		    ObjectName retObject = null;
		    String[] types;
		    if (Util.isLoggableFINEST()) {
			Util.logFINEST("USERNAME TO DELETE ="+model.getValue(deleteKey));
		    }
		    params = new Object[]{model.getValue(deleteKey)};
		    types = new String[]{"java.lang.String"};
		    retObject = (ObjectName)MBeanUtil.invoke(objectName, DELETE_USER,
							params, types);
		    model.setRowSelected(false);
		}
	    }
	} catch (Exception ex) {
	    throw new FrameworkException(
		"Exception while attempting to delete user!", ex, tableDesc, null);
        }        
        ((ContainerViewBase)descView).removeChild(childName);
	((DefaultModel)model).clear();
    }


    //mbean method names
    private static final String GETUSER_GROUPNAME   = "getUserGroupNames";
    private static final String GETUSER_NAME	    = "getUserNames";
    private static final String DELETE_USER	    = "removeUser";

    //DisplayField names
    private static final String USER_ID		= "userId";
    private static final String GROUP_LIST	= "groupList";
    private static final String PASSWORD	= "password";
}
