/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.io.Serializable;
import java.util.StringTokenizer;

import javax.management.ObjectName;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.util.NonSyncStringBuffer;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

public class DynamicTreeNode extends IndexTreeNode implements Serializable {
    
    public DynamicTreeNode(IndexTreeNode parent, String type, String name, IndexTreeModel model) {
	super(parent, type, name, model);
    }
    
    protected void ensureChildren() {
        if (dynamicChild == null)
            return;
        if (getRefresh() == false) 
            return;
        try {
            HashSet newNames = new HashSet();
            updateKids(dynamicChild, newNames);
            removeDeletedNodes(newNames);
        } catch (Exception ex) {
	    if (Util.isLoggableINFO()) {
		Util.logINFO("ERROR in IndexTreeNode.ensureChildren.", ex);
	    }
        }
	setRefresh(false);
    }
    
    private void updateKids(Element element, HashSet newNames) { 
        HashMap params = new HashMap();
        loadParams(element, params);
                
        Object[] objs = getChildObjectNames(params);
        if (objs == null) 
            return;
        
        if (objs instanceof ObjectName[]) {
            ObjectName[] objectNames = (ObjectName[]) objs;

            for (int i = 0; i < objectNames.length; i++) {
                if (!isChildValid(objectNames[i]))
                    continue;

                String name = null;
                String attributeName = (String)params.get("attributeName");
                String attrNameMethod = (String)params.get("attrNameMethod");
                if (attributeName != null && attributeName.length() > 0) {
                    name = (String)MBeanUtil.getAttribute(objectNames[i], 
                                attributeName);
                } else if (attrNameMethod != null && attrNameMethod.length() > 0) {
                    // This is for monitoring MBeans, they don't have a name attr,
                    // but perhaps a getName() method.
                    name = (String)MBeanUtil.invoke(objectNames[i],
                        attrNameMethod, null, null);
                } 
                if (name == null) {
                    // fallback to the object name
                    name = (String) objectNames[i].toString();
                }
                newNames.add(name);
                createNode(element, name, objectNames[i]);
            }
        } else if (objs instanceof String[]) {
            String[] objectNames = (String[]) objs;
            String isWebService = (String)params.get("isWebService");
            for (int i = 0; i < objectNames.length; i++) {
                String name = objectNames[i];
                newNames.add(name);
                IndexTreeNode node = createNode(element, name, objectNames[i]);
                if (node != null && isWebService != null && isWebService.equals("true")) {
                    node.setAttribute("webServiceKey", webServiceKeyMap.get(name));
                    node.setAttribute("webServiceName", name);
                }
            }
        } else {
            if (Util.isLoggableINFO()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append("Illegal type for tree processing:\n");
                buf.append("    TYPE: "+objs.getClass().getName()+"\n");
                buf.append("    OBJECT NAME: "+params.get("objectName")+"\n");
                buf.append("    METHOD NAME: "+params.get("methodName")+"\n");
                Util.logINFO(buf.toString());
            }
            throw new RuntimeException("Illegal type for tree processing");
        }
    }
    
    private Object[] getChildObjectNames(HashMap params) {
        String objectName = (String)params.get("objectName");
        String isWebService = (String)params.get("isWebService");
        Object[] o = null;
        if (isWebService != null && isWebService.equals("true")) {
            webServiceKeyMap.clear();
            String attributeName = (String)params.get("attributeName");
            Map m = (Map)MBeanUtil.getAttribute(objectName, attributeName);                    
            HashSet names = new HashSet();
            // If a web service has the same name, append the application name
            // to make unique. ie, "HelloIF (jaxrpc-simple)"
            HashSet duplicateNames = new HashSet();
            for (Iterator iter = m.entrySet().iterator();iter.hasNext();) {
                Map.Entry entry = (Map.Entry)iter.next();
                String name = (String)entry.getValue();
                webServiceKeyMap.put(name, (String)entry.getKey());
                if (!names.add(name)) {
                    duplicateNames.add(name);
                    String fullName = (String)entry.getKey();
                    String appName = fullName.substring(0, fullName.indexOf('#'));
                    names.add(name + " ("+ appName +")");
                    webServiceKeyMap.put(name + " ("+ appName +")", (String)entry.getKey());
                }
            }
            for (Iterator iter = m.entrySet().iterator();iter.hasNext();) {
                Map.Entry entry = (Map.Entry)iter.next();
                String name = (String)entry.getValue();
                if (duplicateNames.contains(name)) {
                    names.remove(name);
                    String fullName = (String)entry.getKey();
                    String appName = fullName.substring(0, fullName.indexOf('#'));
                    names.add(name + " ("+ appName +")");
                    webServiceKeyMap.put(name + " ("+ appName +")", (String)entry.getKey());
                }
            }
            o = (String[])names.toArray(new String[m.size()]);
        } else {
        
            if (objectName == null || objectName.length() == 0) {
                throw new RuntimeException(
                "Object name parameter is required for tree node: "+getName());
            }            
            objectName = replaceTokens(objectName);
            String methodName = (String)params.get("methodName");
            if (methodName == null || methodName.length() == 0) {
                throw new RuntimeException(
                "Method name parameter is required for tree node: "+getName());
            }        
            String passParams = (String)params.get("passParams");
            Object[] paramsArray = null;
            String[] typesArray  = null;
            if (passParams != null && passParams.equals("false")) {
                paramsArray = null;
                typesArray = null;
            } else {
                paramsArray = new Object[1];
                typesArray  = new String[1];
                String paramData = (String)params.get("paramData");
                paramsArray[0] = replaceTokens(paramData);
                typesArray[0]  = (String)params.get("paramType");
                if (typesArray[0] == null) {
                    typesArray[0] = "java.lang.String";
                }
                if (typesArray[0].equals("boolean") || typesArray[0].equals("java.lang.Boolean")) {
                    paramsArray[0] =  new Boolean(paramsArray[0].toString());
                } else if(typesArray[0].equals("int") || typesArray[0].equals("java.lang.Integer")) {
                    paramsArray[0] =  new Integer(paramsArray[0].toString());
                }
            }
            o = (Object[])MBeanUtil.invoke(objectName, methodName, paramsArray, typesArray);
        }
        return o;
    }
    
    private Map webServiceKeyMap = new HashMap();
}
