/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.sun.enterprise.tools.jsfext.event.EventObjectBase;
import com.sun.enterprise.tools.jsfext.event.UIComponentHolder;

import java.util.EventObject;

import javax.faces.component.UIComponent;


/**
 *
 *  @author Ken Paulsen	(ken.paulsen@sun.com)
 */
public class FilterTreeEvent extends EventObjectBase implements UIComponentHolder {

    /**
     *	<p> Constructor.</p>
     *
     *	@param	component   The <code>UIComponent</code> associated with this
     *			    <code>EventObject</code>.
     */
    public FilterTreeEvent(UIComponent component, Object[] childObjects) {
	super(component);
        setChildObjects(childObjects);
    }

    /**
     *	<p> This method provides access to an array of Objects that are to
     *	    become child <code>TreeNode</code>s.  This allows you to manipluate
     *	    them (filter them) before they are processed.  You may return a new
     *	    Object[] from your handler that processes this event.  Note that
     *	    you NOT set the child object array using this event.</p>
     */
    public Object[] getChildObjects() {
        return _childObjects;
    }
    
    /**
     *	<p> This method is protected because it is only meaningful to set this
     *	    array during the creation of this event.  Setting it any other
     *	    time would not effect the original data structure and would serve
     *	    no purpose.  To provide a different object array, return a new
     *	    <code>Object[]</code> from your handler that processes this
     *	    event.</p>
     */
    protected void setChildObjects(Object[] objects) {
        _childObjects = objects;
    }

    /**
     *	<p> The "filterTree" event type. ("filterTree")</p>
     */
    public static final String	EVENT_TYPE  = "filterTree";
    
    private Object[] _childObjects = null;
}
