/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MBeanTreeImpl.java
 *
 * Created on April 7, 2004, 10:51 PM
 */

package com.sun.enterprise.tools.admingui.tree;

import java.util.ArrayList;
import java.util.HashMap;
import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.BasicTree;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import javax.naming.NameClassPair;

/**
 *
 * @author  anissa
 */
public class MBeanTreeImpl implements BasicTree{
    
    private static final String CLASS_WITH_CHILDREN = "com.sun.enterprise.naming.TransientContext";
    private String hrefURL="";
    private String objectName="";
    private String methodName="";
    private String instanceName="";
    
    /** Creates a new instance of MBeanTreeImpl */
    public MBeanTreeImpl() {
        //System.out.println("MBeanTreeImpl constructor");
    }
    
    public void init(ViewDescriptor viewDescriptor, RequestContext ctx) {
        objectName = (String)viewDescriptor.getParameter("objectName");
        methodName = (String)viewDescriptor.getParameter("methodName");
        hrefURL = (String)viewDescriptor.getParameter("hrefURL");
        instanceName = (String) viewDescriptor.getParameter("instanceName");
        //System.out.println("In MBeanTreeImpl: init() ====");
        if (instanceName==null || "".equals(instanceName)){
            instanceName = (String) ctx.getRequest().getSession().getAttribute("INSTANCE_NAME");
            objectName=objectName+instanceName;
            hrefURL=hrefURL+instanceName;
        }else {
            ctx.getRequest().getSession().setAttribute("INSTANCE_NAME", instanceName);
        }
    }
    
    
    public ArrayList getChildren(Object parent) {
        //System.out.println("!!! getChildren " + ((NameClassPair)parent).getName());
        if (! hasChildren(parent))
        {  
            return new ArrayList();
        }
        NameClassPair ncp = (NameClassPair)parent;
        String context = ncp.getName();
        ArrayList transformed = new ArrayList();
        try {
            ArrayList result = (ArrayList) MBeanUtil.invoke(objectName, methodName, new String[]{context},  new String[] {"java.lang.String"} );
            for(int i=0; i<result.size(); i++){
                NameClassPair pair = (NameClassPair)result.get(i);
                String nm = pair.getName();
                String prepend = context.equals("")? "" : context + "/";
                pair.setName( prepend + pair.getName());
                //System.out.println("Add pair:" + pair.getName());
                transformed.add(pair);
            }
        }catch(Exception ex){
            if (Util.isLoggableINFO()) {
		Util.logINFO("ERROR in MBeanTreeImpl.getChildren()", ex);
	    }
        }
        return transformed;
    }
    
    public Object getRoot() {
        return new NameClassPair("", "");
    }
    
    
    public boolean hasChildren(Object node) {
        NameClassPair ncp = (NameClassPair)node;
        String nm = ncp.getName();
        if (nm.equals(""))   //root node
            return true;
        return ncp.getClassName().equals(CLASS_WITH_CHILDREN);
    }
    
    public String getDisplayName(Object node){
        String fullName = ( (NameClassPair) node).getName();
        String ret = "Jndi Entries Root ( " + instanceName + " )";
        if (!fullName.equals("")){
            int lastIndex = fullName.lastIndexOf('/')+1;
            ret =  fullName.substring(lastIndex );
        }
        return ret;
    }
    
    
    public String getKey(Object node) {
        if (node == null) {
            return "&nodeName=&nodeClass=";
        }
        NameClassPair ncp = (NameClassPair)node;
        return "&nodeName=" + ncp.getName() + "&nodeClass=" + ncp.getClassName();
    }
    
    public String getURL() {
        //System.out.println("getURL()");
        return hrefURL;
    }
    
}
