/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import com.sun.web.ui.common.CCI18N;

import java.util.List;
import java.util.Map;


/**
 *  This class defines a Source mappings from a resource bundle value.
 */
public class ResourceBundleHandlers {

    /**
     *	This method retrieves a localized String from a resource bundle.  The
     *	resource bundle should be stored on one of the parent ViewDescriptors
     *	of this mapper.  The closest one will be used.  Optionally you can
     *	explicitly pass in the "resourceBundle" to use.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getMessage(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Get the key
	String key = (String)handlerCtx.getInputValue(KEY);
	if (key == null) {
	    throw new FrameworkException("'"+KEY+
		"' is required by ResourceBundleMapper.getMappedSource().");
	}

	// Get the resource bundle to use
	String bundle = (String)handlerCtx.getInputValue(RESOURCE_BUNDLE);
	if (bundle == null) {
	    bundle = handlerCtx.getViewDescriptor().getResourceBundle();
	}
	if (bundle == null) {
	    throw new FrameworkException("Resource bundle was not specified!");
	}

	// Create a CCI18N object to help us out
	CCI18N i18n = new CCI18N(reqCtx, bundle); //, null, null);

	// Get the optional list of arguments...
	Object args = handlerCtx.getInputValue(ARGS);
	if (args instanceof List) {
	    args = ((List)args).toArray();
	} else if (args != null) {
	    args = new Object[] {args};
	}

	// Return the result
	handlerCtx.setOutputValue(
	    VALUE, i18n.getMessage(key, (Object [])args));
    }


    /**
     *
     */
    public static final String VALUE	= "value";

    /**
     *	This parameter refers to the key within the resource bundle to use.
     */
    public static final String KEY	= "key";

    /**
     *	This parameter can specify 0 or more arguments to be inserted into the
     *	localized message.
     */
    public static final String ARGS		= "arguments";

    /**
     *	This optional parameter specifies the resourceBundle to use, this has
     *	the highest precedence if used.
     */
    public static final String RESOURCE_BUNDLE	= "resourceBundle";
}
