/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewManager;

import java.util.Iterator;
import java.util.List;
import java.util.Map;


/**
 *
 */
public class ViewHandlers {

    /**
     *	<P>This method locates the specified View.  It requires the id of the
     *	View specified as a Parameter.  The key for the View is "viewID".  The
     *	value of this field may be a List of viewID's -- this walks the
     *	hierachy to the specified View.</P>
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getView(RequestContext reqCtx, HandlerContext handlerCtx) {
	// Get the View ID
	Object viewID = handlerCtx.getInputValue(VIEW_ID);
	if (viewID == null) {
	    throw new FrameworkException(
		"The parameter map did not contain "+VIEW_ID+"!");
	}

	// Try to obtain the ContainerView
	ViewBeanManager vm = reqCtx.getViewBeanManager();
	View view = null;
	String topName = (viewID instanceof List) ?
	    ((List)viewID).get(0).toString() : viewID.toString();
	try {
	    view = vm.getViewBean(topName);
	} catch (ClassCastException ex) {
	    view = ((DescriptorViewManager)vm).getView(null, topName);
	} catch (ClassNotFoundException ex) {
	    throw new FrameworkException(ex);
	}
	if (view == null) {
	    throw new FrameworkException(
		"Unable to obtain the view for mapping!");
	}

	// If we have more than 1 ID, walk the View...
	if (viewID instanceof List) {
	    Iterator iter = ((List)viewID).iterator();
	    iter.next();  // Already used the first one
	    while (iter.hasNext()) {
		if (!(view instanceof ContainerView)) {
		    throw new FrameworkException("View ("+
			view.getQualifiedName()+") is not a ContainerView!",
			null, view);
		}
		view = ((ContainerView)view).getChild(""+iter.next());
	    }
	}

	// Return the View
	handlerCtx.setOutputValue(VALUE, view);
    }


    /**
     *	<P>This method locates the specified View.  It requires the id of the
     *	View specified as a Parameter.  The key for the View is "viewID".  The
     *	value of this field may be a List of viewID's -- this walks the
     *	hierachy to the specified View.</P>
     *
     *  <P>Optionally one more child can be looked up. The child name is
     *  specified in the LEAF_VIEW parameter.
     *
     *	@param	reqCtx		The RequestContext
     *	@param	handlerCtx	The HandlerContext
     */
    public void getQualifiedName(RequestContext reqCtx, HandlerContext handlerCtx) {
	View view = (View)handlerCtx.getOutputValue(VIEW);
	if (view == null) {
	    // We can get the result of the getView() handler using handlerCtx
	    getView(reqCtx, handlerCtx);
	    view = (View)handlerCtx.getOutputValue(VALUE);
	}

	String leaf = (String)handlerCtx.getInputValue(LEAF_VIEW);
	if (leaf != null) {
	    view = ((ContainerView)view).getChild(leaf);
	}

	// Set the output value
	handlerCtx.setOutputValue(VALUE, view.getQualifiedName());
    }


    /**
     *
     */
    public static final String	VALUE =		"value";

    /**
     *
     */
    public static final String	VIEW =		"view";

    /**
     *
     */
    public static final String	VIEW_ID =	"viewID";

    /**
     *
     */
    public static final String LEAF_VIEW	= "leafView";
}
