/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.exception;

import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;


public class FrameworkException extends RuntimeException implements ViewDescriptorHolder {

    /**
     *	This is the preferred constructor.
     */
    public FrameworkException(String msg, Throwable ex, ViewDescriptor viewDesc, View view) {
	super(msg, ex);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkException() {
	super();
    }


    /**
     *
     */
    public FrameworkException(ViewDescriptor viewDesc, View view) {
	super();

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkException(Throwable ex) {
	super(ex);
    }


    /**
     *
     */
    public FrameworkException(Throwable ex, ViewDescriptor viewDesc, View view) {
	super(ex);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkException(String msg) {
	super(msg);
    }


    /**
     *	This is the preferred constructor if there is no root cause.
     */
    public FrameworkException(String msg, ViewDescriptor viewDesc, View view) {
	super(msg);

	// Setup the rest
	setResponsibleViewDescriptor(viewDesc);
	setResponsibleView(view);
    }


    /**
     *
     */
    public FrameworkException(String msg, Throwable ex) {
	super(msg, ex);
    }


    /**
     *	Allow the Exception to hold the responsible View
     */
    public void setResponsibleView(View view) {
	_view = view;
    }


    /**
     *	Allow the Exception to hold the responsible View
     */
    public View getResponsibleView() {
	return _view;
    }


    /**
     *	Allow the Exception to hold the responsible ViewDescriptor
     */
    public void setResponsibleViewDescriptor(ViewDescriptor viewDesc) {
	_viewDesc = viewDesc;
    }


    /**
     *	Allow the responsible ViewDescriptor to be obtained.
     *
     *	@return The responsible ViewDescriptor (null if not specified)
     */
    public ViewDescriptor getResponsibleViewDescriptor() {
	return _viewDesc;
    }


    private View		_view		= null;
    private ViewDescriptor	_viewDesc	= null;
}
