/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Constructors
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// construct a javascript object for maintaining focus via a cookie
function ccFocusCookie(name, path) {
    // call the base constructor
    this(name);

    this.$path = path;
}

// this constructor is called by the one above and is left for compatability
// with 2.0 apps
function ccFocusCookie(name) {
    // All predefined properties of this object begin with '$' because
    // we don't want to store these values in the cookie.
    this.$cookieName = name;

    // Default properties.
    this.id   = "";
    this.name = "";
    this.form = "";

    // Object methods from cookie.js
    this.get   = ccGetCookie;
    this.load  = ccLoadCookie;
    this.reset = ccResetCookie;
    this.show  = ccShowCookie;
    this.store = ccStoreCookie;

    // Object methods from focusCookie.js
    this.restore = ccRestoreFocusCookie;
    this.set     = ccSetFocusCookie;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Functions
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// This function will restore the cookie value.
function ccRestoreFocusCookie() {
    // Load cookie value.
    this.load();
    var elements = null;

    // If name isn't set, don't parse elements.
    if (this.name == "")
        return false;

    // If form doesn't exist, it's a link.
    if (this.form)
        elements = eval("document." + this.form + ".elements");
    else
        elements = document.links;

    // Parse each form element and test name and id.
    for (i = 0; i < elements.length; i++) {
        if (this.name == elements[i].name) {
            if (this.id != "" && this.id != elements[i].id)
                continue;
            
            // Test if element is disabled.
            if (elements[i].disabled)
                return false;
            
            // Set element focus.
            elements[i].focus();
            return true;
        }
    }

    return false;
}

// This function will set the cookie value.
function ccSetFocusCookie(element) {
    if (element == null)
	return false;

    // Set object properties.
    if (element.id)
        this.id = element.id;
    else
        this.id = "";
    if (element.name)
        this.name = element.name;
    else
        this.name = "";
    if (element.form)
        this.form = element.form.name;
    else
        this.form = "";

    // Store cookie value.
    this.store();

    return true;
}

//-->
