<%--
 The contents of this file are subject to the terms 
 of the Common Development and Distribution License 
 (the License).  You may not use this file except in
 compliance with the License.
 
 You can obtain a copy of the license at 
 https://glassfish.dev.java.net/public/CDDLv1.0.html or
 glassfish/bootstrap/legal/CDDLv1.0.txt.
 See the License for the specific language governing 
 permissions and limitations under the License.
 
 When distributing Covered Code, include this CDDL 
 Header Notice in each file and include the License file 
 at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 If applicable, add the following below the CDDL Header, 
 with the fields enclosed by brackets [] replaced by
 you own identifying information: 
 "Portions Copyrighted [year] [name of copyright owner]"
 
 Copyright 2006 Sun Microsystems, Inc. All rights reserved.
--%>
<%@page language="java" %>
<%@page import="com.sun.web.ui.common.CCI18N" %>
<%@page import="com.sun.web.ui.common.CCSystem" %>
<%@page import="com.iplanet.jato.util.NonSyncStringBuffer" %>
<%@page import="java.net.URL" %>
<%@page import="java.net.URLEncoder" %>

<%@taglib uri="/jato.tld" prefix="jato" %>
<%@taglib uri="/cc.tld" prefix="cc" %>

<%
  // Params from the URL.
  String appName = (request.getParameter("appName") != null)
    ? request.getParameter("appName") : "";
  if (appName == null || appName.equals("")) {
    appName = request.getContextPath();
    if (appName == null) {
      appName = "";
    } else if (appName.startsWith("/")) {
      appName = appName.substring(1);
    }
  }

  // Get query parameters.
  String windowTitle = (request.getParameter("windowTitle") != null)
    ? request.getParameter("windowTitle") : "";
  String mastheadTitle = (request.getParameter("mastheadTitle") != null)
    ? request.getParameter("mastheadTitle") : "";
  String mastheadAlt = (request.getParameter("mastheadAlt") != null)
    ? request.getParameter("mastheadAlt") : "";
  String helpFile = (request.getParameter("helpFile") != null)
    ? request.getParameter("helpFile") : "";
  String helpLogoHeight= (request.getParameter("helpLogoHeight") != null)
    ? request.getParameter("helpLogoHeight") : "";
  String helpLogoWidth = (request.getParameter("helpLogoWidth") != null)
    ? request.getParameter("helpLogoWidth") : "";
  String firstLoad = (request.getParameter("firstLoad") != null)
    ? request.getParameter("firstLoad") : "false";

  // This param is used in several places; use a var rather than encoding it
  // multiple times.
  String windowTitleEncoded =
    "windowTitle=" + URLEncoder.encode(windowTitle, CCI18N.UTF8_ENCODING);

  // src value for the Masthead frame.
  String mastheadSrc = (new NonSyncStringBuffer(CCSystem.getResourceContextPath()))
    .append("/help2/Masthead?mastheadTitle=")
    .append(URLEncoder.encode(mastheadTitle, CCI18N.UTF8_ENCODING))
    .append("&amp;mastheadAlt=")
    .append(URLEncoder.encode(mastheadAlt, CCI18N.UTF8_ENCODING))
    .append("&amp;helpLogoWidth=")
    .append(URLEncoder.encode(helpLogoWidth, CCI18N.UTF8_ENCODING))
    .append("&amp;helpLogoHeight=")
    .append(URLEncoder.encode(helpLogoHeight, CCI18N.UTF8_ENCODING))
    .append("&amp;")
    .append(windowTitleEncoded).toString();

  // src value for the Navigator frame.
  String navigatorSrc = (new NonSyncStringBuffer(CCSystem.getResourceContextPath()))
    .append("/help2/Navigator?")
    .append(windowTitleEncoded)
    .append("&amp;firstLoad=")
    .append(URLEncoder.encode(firstLoad, CCI18N.UTF8_ENCODING))
    .append("&amp;appName=")
    .append(URLEncoder.encode(appName, CCI18N.UTF8_ENCODING))
    .append("&amp;helpFile=")
    .append(URLEncoder.encode(helpFile, CCI18N.UTF8_ENCODING)).toString();

  // src value for the ButtonNav frame.
  String buttonNavSrc = (new NonSyncStringBuffer(CCSystem.getResourceContextPath()))
    .append("/help2/ButtonNav?")
    .append(windowTitleEncoded).toString();
%>

<jato:useViewBean className="com.sun.web.ui.servlet.help2.Help2ViewBean">

<html>
<head>
  <title><%=windowTitle %></title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="Copyright" content="Copyright &copy; 2004 by Sun Microsystems, Inc. All Rights Reserved.">
  <cc:stylesheet />
</head>

<cc:i18nbundle name="i18nBundle" id="help2Bundle"
 baseName="com.sun.web.ui.resources.Resources" />

<!-- Frameset for Masthead frame -->
<frameset rows="110,*"
 frameborder="0"
 border="0"
 framespacing="0">

<!-- Masthead frame -->
<frame src="<%=mastheadSrc %>"
 name="mastheadFrame"
 scrolling="no"
 id="mastheadFrame"
 title="Frame Containing Masthead and Page Title" />

<!-- Frameset for Nav, ButtonNav, and Content frames -->
<frameset cols="33%,67%"
 framespacing="2"
 frameborder="1"
 border="2"
 bordercolor="#CCCCCC">

<!-- Nav Frame -->
<frame src="<%=navigatorSrc %>"
 name="navFrame"
 frameborder="0"
 scrolling="auto"
 id="navFrame"
 title="Frame Containing Table of Contents, Index, and Search" />

<!-- Frameset for ButtonNav and Content Frames -->
<frameset rows="31,*"
 framespacing="1"
 frameborder="1"
 border="1"
 bordercolor="#CCCCCC">

<!-- ButtonNav Frame -->
<frame src="<%=buttonNavSrc %>"
 name="buttonNavFrame"
 frameborder="0"
 scrolling="no"
 id="buttonNavFrame"
 title="Frame Containing Navigation Buttons" />

<!-- Content Frame -->
<frame src="<%=helpFile %>"
 name="contentFrame"
 frameborder="0"
 scrolling="auto"
 id="contentFrame"
 title="Frame Containing Online Help Text" />

</frameset>
</frameset>
</frameset>

<noframes>
<body>
<cc:text name="NoFramesText" bundleID="help2Bundle"
 defaultValue="help.noframes" />
</body>
</noframes>

</html>

</jato:useViewBean>
