/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.ApplicationServletBase;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.view.wizard.CCWizardPage;

import javax.servlet.http.HttpServletRequest;


public class DescriptorCCWizardPage extends DescriptorRequestHandlingViewBase implements CCWizardPage {

    /**
     *	<P>This class does not get created in the usual way.  This constructor
     *	accomodates the way the lockhart wizard does its work.  It only accepts
     *	the container and model... however, the model name can be used to get
     *	the ViewDescriptor and we'll get the RequestContext statically.</P>
     *
     *	<P>NOTE: The model passed in must be assignable to DefaultModel.</P>
     */
    public DescriptorCCWizardPage(View view, Model model) {
	this(
	    RequestManager.getRequestContext(),
	    (ContainerView)view,
	    ((DefaultModel)model).getName(),
	    ViewDescriptorManager.getInstance().getViewDescriptor(RequestManager.getRequestContext().getRequest().getAttribute(VIEW_DESCRIPTOR_NAME).toString()),
	    model);
    }


    /**
     *	This method overrides JATO's getParentViewBean().  This class will be
     *	used as a Pagelet that doesn't know what its parent is.  This method
     *	finds the top via the request using PathInfo.
     */
    public ViewBean getParentViewBean() {
	// Try to get the page name
	RequestContext rc = RequestManager.getRequestContext();
	HttpServletRequest request = rc.getRequest();
	String pageName = request.getParameter(ApplicationServletBase.PARAM_HANDLER_BEAN);
	if (pageName == null) {
	    pageName = request.getPathInfo();
	}
	if (pageName != null) {
	    pageName = pageName.trim();
	    while (pageName.charAt(0) == '/') {
		pageName = pageName.substring(1);
	    }
	    try {
		return rc.getViewBeanManager().getViewBean(pageName);
	    } catch (ClassNotFoundException ex) {
		// Ignore...
	    }
	}
	return null;
    }


    /**
     *	Constructor
     */
    public DescriptorCCWizardPage(RequestContext ctx, ContainerView container, String name, ViewDescriptor desc) {
	this(ctx, container, name, desc, null);
    }


    /**
     *	Constructor
     */
    public DescriptorCCWizardPage(RequestContext ctx, ContainerView container, String name, ViewDescriptor desc, Model model) {
	super(ctx, container, name, desc, model);
    }



    ////////////////////////////////////////////////////////////
    //                 CCWizardPage Method                    //
    ////////////////////////////////////////////////////////////

    /**
     *
     *	Get the pagelet to use for the rendering of this instance.
     *
     *	@return The pagelet to use for the rendering of this instance.
     */
    public String getPageletUrl() {
	return getViewDescriptor().getDisplayURL();
    }


    /**
     *	A ServletRequest attribute VIEW_DESCRIPTOR_NAME, should be set to the
     *	ViewDescriptor name that should be instantiated when using the 2 arg
     *	constructor.
     */
    public static final String VIEW_DESCRIPTOR_NAME	= "_VD_NAME";

    /**
     *	ModelManager name for the Wizard Model
     */
    public static final String WIZARD_MODEL = "_wizModel";
}
