/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.exception.FrameworkError;
import com.sun.enterprise.tools.guiframework.event.descriptors.EventDescriptor;

import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.model.wizard.WizardInterfaceExt;
import com.sun.web.ui.model.CCWizardWindowModelInterface;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.EventObject;


/**
 *  <p>	I would have liked to have WizardWindowViewBean implement WizardImpl,
 *  however, the tags hard-code "WizardWindow" all over the place making it so
 *  only 1 instance of WizardWindowViewBean can exist.  So, I was forced to
 *  make this a separate class.</p>
 *
 *  <p> This implementation of WizardInterface uses Descriptor information
 *  stored in the ViewXML to define its information.  However, even though it
 *  is defined as a "displayItem" in the ViewXML, it is not a View of any type.
 *  Hopefully in the in future this class can be merged with
 *  DescriptorWizardWindowViewBean.</p>
 */

public class DescriptorWizardImpl implements WizardInterface, java.io.Serializable, WizardInterfaceExt {

    /**
     *  Constructor.
     *
     *  @param  ctx The RequestContext
     *  @param  name    The name of the ViewBean
     */
    public DescriptorWizardImpl(RequestContext ctx, String name) {
	// setRequestContext(ctx); Cannot store this b/c LH caches this obj.
	if (name == null) {
	    throw new FrameworkException("Wizard name cannot be null!  It "
		    + "is required to find the ViewDescriptor!");
	}
	setName(name);
	ViewDescriptor viewDesc =
	    ViewDescriptorManager.getInstance().getViewDescriptor(name);
	if (viewDesc == null) {
	    throw new FrameworkException("ViewDescriptor for wizard '" + name
		    + "' not found!");
	}
	setViewDescriptor(viewDesc);
	//  registerViewDescriptorChildren();  Not a displayitem
    }

    private List sequence = new ArrayList();

    /**
     *
     */
    protected void initialize(ViewDescriptor desc) {

	boolean firstBranch = false;

	// Wizard level parameters...
	setResourceBundle("" + desc.getParameter(RESOURCE_BUNDLE));
	setTitle("" + desc.getParameter(WIZARD_TITLE));

	// Page level parameters...
	List pages = desc.getChildDescriptors();
	Iterator it = pages.iterator();
	while (it.hasNext()) {
	    WizardPage wizardPage = new WizardPage((ViewDescriptor) it.next());
	    addWizardPage(wizardPage);
	    //Create the first sequence of mainSteps not including sub steps
	    if (!wizardPage.isSubStep()) {
		sequence.add(wizardPage);
	    }

	    if (wizardPage.isResultsPage()) {
		showResultsPage = true;
	    }
	}
    }


    /**
     *  We cannot cache the request context here b/c LH caches this object,
     *  making the request context invalid on subsequent requests.
     */
    public RequestContext getRequestContext() {
	return RequestManager.getRequestContext();
    }


    /**
     *  This method sets the ViewDescriptor for this View.  This method also
     *  initializes the Wizard from the ViewDescriptor information.
     *
     *  @param desc The ViewDescriptor
     */
    protected void setViewDescriptor(ViewDescriptor desc) {
	_viewDesc = desc;
	initialize(desc);
    }


    /**
     *  This method retrieves this View ViewDescriptor.
     *
     *  @return This View's ViewDescriptor.
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    /**
     *
     */
    protected void addWizardPage(WizardPage wizardPage) {
	getWizardPages().add(wizardPage);
    }


    /**
     *
     */
    protected void setWizardPages(List pages) {
	_wizardPages = pages;
    }


    /**
     *
     */
    public List getWizardPages() {
	return _wizardPages;
    }


    /**
     *
     */
    public WizardPage getWizardPage(String pageId) {
	return getWizardPage(pageIdToPage(pageId));
    }


    /**
     *
     */
    public WizardPage getWizardPage(int index) {
	//return (WizardPage)getWizardPages().get(index);
	return (WizardPage) sequence.get(index);
    }



    ////////////////////////////////////////////////////////////
    //               WizardInterface Methods                  //
    ////////////////////////////////////////////////////////////

    /**
     *  Factory method.
     */
    public static WizardInterface create(RequestContext ctx) {
	// FIXME: Hack b/c LH does not provide a way to get the WIZARD_NAME
	// FIXME: Hack b/c LH hard-codes "WizardWindow."
	String wizardName =
	    ctx.getRequest().getParameter(WIZARD_WINDOW_PARAMETER_NAME);

	return new DescriptorWizardImpl(ctx, wizardName);
    }


    /**
     *  <p>Returns the name of this WizardInterface implementation.</p>
     *
     *  <p>This method conflicts with View.getName()... however, I don't think
     *  it is very important, so I'm going to return super.getName().</p>
     */
    public String getName() {
	return _wizName;
    }


    /**
     *  This sets the WizardName.  NOTE: The wizard name should correspond to
     *  a displayItem entry in the view xml.
     */
    public void setName(String name) {
	_wizName = name;
    }


    /**
     *  <p>Return the Model that the wizard framework should assign to the
     *  WizardPage instance for the given pageId.</p>
     */
    public Model getPageModel(String pageId) {
	WizardPage page = getWizardPage(pageId);
	return page.getModel();
    }


    /**
     *  <p>Return the Class name of the WizardPage instance to construct for
     *  this pageId.</p>
     */
    public Class getPageClass(String pageId) {
	// I need this to know what ViewDescriptor to use.
	getRequestContext().getRequest().setAttribute(
	    DescriptorCCWizardPage.VIEW_DESCRIPTOR_NAME,
	    getWizardPage(pageId).getName());

	// All our pages are Descriptor pages
	return DescriptorCCWizardPage.class;
    }


    /**
     *  Return the View name of the WizardPage instance for this pageId.
     */
    public String getPageName(String pageId) {
	// FIXME: Provide logging API
	//System.out.println("getPageName("+pageId+")");
	return getWizardPage(pageId).getName();
    }


    /**
     *  The first page in the sequence of Wizard steps.  This returned String
     *  is a internal Wizard identifier and will be used to identify other
     *  required Wizard information, such as a step's instructional text.
     */
    public String getFirstPageId() {
	// FIXME: Provide logging API
	//System.out.println("getFirstPageId(): "+pageToPageId(firstPage));
	return pageToPageId(0);
    }


    /**
     *  The next page in the Wizard's defined sequence relative to pageId.
     */
    public String getNextPageId(String pageId) {
	// FIXME: Provide logging API
	//System.out.println("getNextPageId("+pageId+")");
	if (isFinishPageId(pageId) && !showResultsPage) {
	    return null;
	}
	return pageToPageId(pageIdToPage(pageId) + 1);
    }


    /**
     *  The path to a resource properties file.  The path should define String
     *  keys to support I18N translations. Strings such as a steps instructions
     *  are expected to be keys defined in this file.
     */
    public String getResourceBundle() {
	// FIXME: Provide logging API
	//System.out.println("getResourceBundle()");
	return _resourceBundle;
    }


    /**
     *  Method to set the resource bundle.
     */
    public void setResourceBundle(String resBundle) {
	_resourceBundle = resBundle;
    }

    /**
     *  The overall title for the wizard window.
     */
    public String getTitle() {
	return _title;
    }


    /**
     *  Setter for the overall title for the wizard window.
     */
    public void setTitle(String title) {
	_title = title;
    }


    /**
     *  <p>The title for this step.  It appears above the page contect with the
     *  "Step N" label. For example:</p>
     *
     *  <p><B>Step 1: Entering the User's Name</B></p>
     */
    public String getStepTitle(String pageId) {
	return getWizardPage(pageId).getStepText();
    }


    /**
     *  The expected future page id's from the specified page id.  If there are
     *  branches in the future sequence only those page id's up to the page id
     *  before the branch are returned. For example assuming currentPageId is
     *  2, if the the future page id's are 3, 4, 5a, 5b, only page id's 3, and
     *  4 would be returned.
     */
    public String[] getFuturePages(String currentPageId) {
	// Add 1 to skip this page
	if (isResultsPage(currentPageId)) {
	    return null;
	}

	int page = pageIdToPage(currentPageId) + 1;
	int howMany = sequence.size() - page;
	//String[] futurePages = new String[howMany];
	/*List futurePages = new ArrayList();
	for (int i = 0; i < howMany; ++i, ++page) {
	    // No conversion
	    if (((WizardPage)pages.get(page)).isSubStep())
		break;
	    futurePages.add(i, pageToPageId(page));
	}
	return (String[])futurePages.toArray(new String[futurePages.size()]);*/

	String [] futurePages = new String[howMany];
	for (int cnt = 0; cnt < howMany; ++cnt, ++page) {
	    futurePages[cnt] = pageToPageId(page);
	}
	return futurePages;
    }

    /**
     *  The step instructions for the future pages in the same sequence as the
     *  page id's from getFuturePages.
     */
    public String[] getFutureSteps(String currentPageId) {
	// Add 1 to skip this page
	int page = pageIdToPage(currentPageId) + 1;
	//List pages = getWizardPages();
	int howMany = sequence.size() - page;
	//List futureSteps = new ArrayList();
	String[] futureSteps = new String[howMany];
	for (int i = 0; i < howMany; ++i, ++page) {
	    /*if (((WizardPage)pages.get(page)).isSubStep())
		break;
	    futureSteps.add(i, ((WizardPage)pages.get(page)).getStepText());*/
	    futureSteps[i] = ((WizardPage) sequence.get(page)).getStepText();
	}
	//return (String[])futureSteps.toArray(new String[futureSteps.size()]);
	return futureSteps;
    }


    /**
     *  <p>The instructions that describe the step identified by pageId.</p>
     */
    public String getStepInstruction(String pageId) {
	// FIXME: Provide logging API
	//System.out.println("getStepInstructions("+pageId+")");
	return getWizardPage(pageId).getStepInstructions();
    }


    /**
     *  The step summary for the step specified by pageId.
     */
    public String getStepText(String pageId) {
	return getWizardPage(pageId).getStepText();
    }


    /**
     *  Help text for the step identified by pageId. Each array element will
     *  appear as an html para.
     */
    public String[] getStepHelp(String pageId) {
	return getWizardPage(pageId).getStepHelp();
    }


    /**
     *  Returning true indicates that pageId identifies the last step in the
     *  sequence.
     */
    public boolean isFinishPageId(String pageId) {
	//return (pageIdToPage(pageId) == (getWizardPages().size()-1));
	//return pageId.equals(finishPageId);
	int currentPage = pageIdToPage(pageId);
	return ((WizardPage) sequence.get(currentPage)).isFinishPage();
    }


    /**
     *  This method returns false if step is reached such that the user cannot
     *  return to the previous step. If this message returns true the user will
     *  not be able to return to any visited steps.  If the user can return to
     *  the previous step this method returns true.
     */
    public boolean hasPreviousPageId(String pageId) {
	return !(getFirstPageId().equals(pageId));
    }


    /**
     *  This method returns a context sensitive message relative to the
     *  specified pageId.  The String is usually a resource key. The returned
     *  String will be used as the message displayed in the cancel prompt.
     */
    public String getCancelPrompt(String pageId) {
	return getWizardPage(pageId).getCancelPrompt();
    }


    /**
     * A String that identifies the wizard.
     */
    public String toString() {
	return this.getClass().getName() + "(" + getName() + ") with "
	    + getWizardPages().size() + " pages.";
    }


    /**
     *  This method is called when the framework has determined that the user
     *  is through using the wizard application. If the method returns true the
     *  framework will remove the wizard from its cache.  It is up to wizard to
     *  ensure that no other applications are referencing this wizard at this
     *  time. (For statelss wizards)
     */
    public boolean done(String wizardName) {
	/*RequestContext rc = getRequestContext();
	WizardEvent event = new WizardEvent(rc, null, null, null, wizardName);
	try {
	    return DescriptorViewHelper.endWizard(getViewDescriptor(), event);
	} catch (Exception ex) {
	    throw new FrameworkError(ex, getViewDescriptor(), event.getView());
	}*/
	ViewDescriptor viewDesc = getViewDescriptor();
	EventObject event = new EventObject(wizardName);
	Object result = null;
	try {
	    // Dispatch Begin Display Event Handlers (and mappings)
	    result = DescriptorViewHelper.dispatchEvent(getRequestContext(),
		    null, viewDesc,
		    viewDesc.getEventDescriptor(
			EventDescriptor.TYPES.END_WIZARD),
		    event);
	} catch (FrameworkException ex) {
	    // Change to an error
	    throw new FrameworkError(
		    ex,
		    ex.getResponsibleViewDescriptor(),
		    ex.getResponsibleView());
	} catch (Exception ex) {
	    throw new FrameworkError(ex, viewDesc, (View) null);
	}

	boolean retVal = true;
	if (result instanceof Boolean) {
	    retVal = ((Boolean) result).booleanValue();
	}
	return retVal;
    }


    /**
     *  <p>This method is called when the user clicks the next button. If true
     *  is returned the next page for the next step is displayed.</p>
     *
     *  <p>If false is returned the framework will expect that a message has
     *  been set in in wizardEvent that will appear in a popup window. A
     *  severity must also be indicated. The severity can be informational
     *  requiring the user acknowledge and dismiss the popup window, a question
     *  indicating that the user can cancel or continue, and fatal where the
     *  user must acknowledge and dismiss the popup window and the wizard will
     *  quit.</p>
     */
    public boolean nextStep(WizardEvent wizardEvent) {
	// FIXME: Provide logging API
	//((DefaultModel)getPageModel(wizardEvent.getPageId())).
	//	dumpValues(System.out);
	RequestContext rc = getRequestContext();
	try {
	    boolean continueWizard =  DescriptorViewHelper.nextWizardStep(
		(DescriptorContainerView) wizardEvent.getView(), wizardEvent);
	    String pageId = wizardEvent.getPageId();
	    WizardPage wizPage = getWizardPage(pageId);
	    Model model = wizPage.getModel();

	    if (!continueWizard) {
		//There is an error and the model should contain the error
		String errorMessage = (String) model.getValue(ERROR_MESSAGE);
		int severity = ((Integer) model.getValue(SEVERITY)).intValue();
		wizardEvent.setErrorMessage(errorMessage);
		wizardEvent.setSeverity(severity);
		return false;
	    }

	    if (wizPage.isBranchStep()) {
		/*  The branchStep should define a boolean displayField that
		 *  will cause the display of the sub steps*/

		boolean showSteps = new Boolean(
			(String) model.getValue(SHOW_STEPS)).booleanValue();
		if (showSteps) {
		    // Recreate sequence to show the steps for this branch only
		    List pages = getWizardPages();
		    int currentPage = pageIdToPage(pageId);
		    sequence.subList(currentPage + 1, sequence.size()).clear();
		    int startIdx = currentPage + 1;
		    for (int i = startIdx; i < pages.size(); i++, startIdx++) {
			WizardPage page = (WizardPage) pages.get(i);
			if (page.isSubStep()) {
			    sequence.add(page);
			} else {
			    break;
			}
		    }
		    for (int i = startIdx; i < pages.size(); i++) {
			WizardPage page = (WizardPage) pages.get(i);
			if (!page.isSubStep()) {
			    sequence.add(page);
			}
		    }
		} else {
		    //need to clear the substeps if they have been added
		    //only immediate substeps will be removed
		    int startIdx = pageIdToPage(pageId) + 1;
		    List removes = new ArrayList();
		    for (int i = startIdx; i < sequence.size(); i++) {
			WizardPage page = (WizardPage) sequence.get(i);
			if (page.isSubStep()) {
			    removes.add(page);
			} else {
			    break;
			}
		    }
		    sequence.removeAll(removes);
		}
	    }
	    return continueWizard;
	} catch (Exception ex) {
	    throw new FrameworkError(
		    ex,
		    getViewDescriptor(),
		    wizardEvent.getView());
	}
    }


    /**
     *  <p>This method is called when the user clicks the previos button. If
     *  true is returned the previous page for the next step is displayed.</p>
     *
     *  <p>If false is returned the framework will expect that a message has
     *  been set in in wizardEvent that will appear in a popup window. A
     *  severity must also be indicated. The severity can be informational
     *  requiring the user acknowledge and dismiss the popup window, a question
     *  indicating that the user can cancel or continue, and fatal where the
     *  user must acknowledge and dismiss the popup window and the wizard will
     *  quit.</p>
     */
    public boolean previousStep(WizardEvent wizardEvent) {
	// FIXME: Provide logging API
	//((DefaultModel)getPageModel(wizardEvent.getPageId())).
	//	dumpValues(System.out);
	RequestContext rc = getRequestContext();
	try {
	    return DescriptorViewHelper.prevWizardStep(
		    (DescriptorContainerView) wizardEvent.getView(),
		    wizardEvent);
	} catch (Exception ex) {
	    throw new FrameworkError(
		    ex,
		    getViewDescriptor(),
		    wizardEvent.getView());
	}
    }


    /**
     *  <p>This method is called when the user clicks a link to a previously
     *  seen page.  If true is returned the wizard will proceed to the linked
     *  location.</p>
     *
     *  <p>If false is returned the framework will expect that a message has
     *  been set in in wizardEvent that will appear in a popup window. A
     *  severity must also be indicated. The severity can be informational
     *  requiring the user acknowledge and dismiss the popup window, a question
     *  indicating that the user can cancel or continue, and fatal where the
     *  user must acknowledge and dismiss the popup window and the wizard will
     *  quit.</p>
     *
     *  <p>The window event will include the target page id.</P.
     */
    public boolean gotoStep(WizardEvent wizardEvent) {
	RequestContext rc = getRequestContext();
	try {
	    return DescriptorViewHelper.goToWizardStep(
		    (DescriptorContainerView) wizardEvent.getView(),
		    wizardEvent);
	} catch (Exception ex) {
	    throw new FrameworkError(
		    ex,
		    getViewDescriptor(),
		    wizardEvent.getView());
	}
    }


    /**
     *  <p>This method is called when the user clicks the finish button. The
     *  return value from the the wizard is ignored and on return the wizard
     *  framework will dismiss the remaining window.</p>
     *
     *  <p>The framework assumes that the wizard application will never allow
     *  the finish step to occur if it is not ready to end interacting with the
     *  user.</p>
     *
     *  <p>The framework will call the getFinishPrompt method before a page is
     *  displayed. The wizard must return a context sensitive message relative
     *  to the specified page. The message will be used as the finish prompt
     *  message. A finish prompt is always a WizardEvent.ACKNOWLEDGE
     *  severity.</p>
     */
    public boolean finishStep(WizardEvent wizardEvent) {
	RequestContext rc = getRequestContext();
	try {
	    boolean result = DescriptorViewHelper.finishWizardStep(
		(DescriptorContainerView) wizardEvent.getView(), wizardEvent);
	    if (!result) {
		stopWizardFromClosing(wizardEvent.getView().getParent());
	    }
	    return result;
	} catch (Throwable ex) {
	    stopWizardFromClosing(wizardEvent.getView().getParent());
	    throw new FrameworkError(
		    ex,
		    getViewDescriptor(),
		    wizardEvent.getView());
	}
    }


    /**
     *  Hack to fix LH bug.  This method sets the CCWizard.isFinishRequest to
     *  false.  It uses reflection to do this in order to access this private
     *  variable.
     */
    private void stopWizardFromClosing(View view) {
	if (!(view instanceof com.sun.web.ui.view.wizard.CCWizard)) {
	    return;
	} try {
	    Field [] fields = view.getClass().getDeclaredFields();
	    int idx;
	    for (idx = 0; idx < fields.length; idx++) {
		if (fields[idx].getName().equals("isFinishRequest")) {
		    break;
		}
	    }
	    fields[idx].setAccessible(true);
	    fields[idx].setBoolean(view, false);
	} catch (Exception ex) {
	    // Ignore
	}
    }


    /**
     *  <p>This method is called when the user clicks the cancel button. The
     *  return value from the the wizard is ignored and on return the wizard
     *  framework will dismiss the remaining window.</p>
     *
     *  <p>The framework will call the getCancelPrompt method before a page is
     *  displayed. The wizard must return a context sensitive message relative
     *  to the specified page. The message will be used as the cancel prompt
     *  message. A cacel prompt is always a WizardEvent.QUERY severity.</p>
     */
    public boolean cancelStep(WizardEvent wizardEvent) {
	RequestContext rc = getRequestContext();
	try {
	    return DescriptorViewHelper.cancelWizardStep(
		    (DescriptorContainerView) wizardEvent.getView(),
		    wizardEvent);
	} catch (Exception ex) {
	    throw new FrameworkError(
		    ex,
		    getViewDescriptor(),
		    wizardEvent.getView());
	}
    }


    /**
     * Return true to warn the user once when revisiting a
     * previous page as follows.
     *<p>
     * In wizards, if you change entries on pages that you<br>
     * have already visited, you will likely lose information<br>
     * that you entered on later pages.
     *<p>
     * Return false to never warn the user.
     * If your wizard implementation does not have dependecies
     * as inferred by the warning, return false.
     * <p>
     * This method is called once after creating the WizardInterface
     * instance.
     */
    public boolean warnOnRevisitStep() {
	return false;
    }


    /**
     *
     */
    private String pageToPageId(int page) {
	return Integer.toString(page + 1);
    }


    /**
     *
     */
    private int pageIdToPage(String pageId) {
	return Integer.parseInt(pageId) - 1;
    }

    public boolean canBeStepLink(String pageId) {
	return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
    }

    public String getPlaceholderText(String pageId) {
	/*if (showResultsPage) {
	    return null;
	}
	return "PlaceHolderText";*/
	if (isResultsPage(pageId)) {
	    return null;
	}
	return getWizardPage(pageId).getPlaceHolderText();
    }

    public String getResultsPageId(String pageId) {
	if (showResultsPage) {
	    return (new Integer(sequence.size())).toString();
	}
	return null;
    }

    public boolean helpTab(WizardEvent wizardEvent) {
	return true;
    }

    public boolean isSubstep(String pageId) {
	//TODO Check if this is a substep
	if (isResultsPage(pageId)) {
	    return false;
	}
	return getWizardPage(pageId).isSubStep();
    }

    public boolean stepTab(WizardEvent wizardEvent) {
	return true;
    }

    ///////////////////////////////////////////////////////////

    protected boolean isResultsPage(String pageId) {
	return ((WizardPage) sequence.get(
		    pageIdToPage(pageId))).isResultsPage();
    }
    /**
     *  Inner class to hold WizardPage information.
     */
    protected class WizardPage implements java.io.Serializable {
	public WizardPage(ViewDescriptor viewDesc) {
	    initialize(viewDesc);
	}

	protected void initialize(ViewDescriptor viewDesc) {
	    setName(viewDesc.getName());
	    setStepText("" + viewDesc.getParameter(STEP_TEXT));
	    setStepInstructions("" + viewDesc.getParameter(STEP_INSTRUCTIONS));
	    setCancelPrompt("" + viewDesc.getParameter(CANCEL_PROMPT));
	    setPageModelName((String) viewDesc.getParameter(PAGE_MODEL_NAME));
	    setPageModelClass((String) viewDesc.getParameter(PAGE_MODEL_CLASS));

	    // Step help needs to be an array of String
	    List stepHelp = (List) viewDesc.getParameter(STEP_HELP);
	    if (stepHelp != null) {
		setStepHelp((String []) stepHelp.toArray(
			    new String[stepHelp.size()]));
	    }

	    String resultsPage = (String) viewDesc.getParameter(RESULTS_PAGE);
	    if ((resultsPage != null) && resultsPage.equalsIgnoreCase("true")) {
		_resultsPage = true;
	    }

	    String finishPage = (String) viewDesc.getParameter(FINISH_PAGE);
	    if ((finishPage != null) && finishPage.equalsIgnoreCase("true")) {
		_finishPage = true;
	    }

	    String branchStep = (String) viewDesc.getParameter(BRANCH_STEP);
	    if ((branchStep != null) && branchStep.equalsIgnoreCase("true")) {
		_branchStep = true;
		String placeHolderText =
		    (String) viewDesc.getParameter(PLACE_HOLDER_TEXT);
		setPlaceHolderText(placeHolderText);
	    }

	    String subStep = (String) viewDesc.getParameter(SUB_STEP);
	    if ((subStep != null) && subStep.equalsIgnoreCase("true")) {
		if (_branchStep) {
		    throw new FrameworkException(
			    viewDesc.getName()
			    + " cannot be a branchStep as well as a subStep");
		}
		_subStep = true;
	    }
	}


	/**
	 *  @param name The wizard page name
	 */
	public void setName(String name) {
	    _name = name;
	}


	/**
	 *  @return The wizard page name
	 */
	public String getName() {
	    return _name;
	}


	/**
	 *  @param stepText The wizard page step text
	 */
	public void setStepText(String stepText) {
	    _stepText = stepText;
	}


	/**
	 *  @return The wizard page step text
	 */
	public String getStepText() {
	    return _stepText;
	}


	/**
	 *  @param stepInstructions The wizard page step instructions
	 */
	public void setStepInstructions(String stepInstructions) {
	    _stepInstructions = stepInstructions;
	}


	/**
	 *  @return The wizard page step instructions
	 */
	public String getStepInstructions() {
	    return _stepInstructions;
	}


	/**
	 *  @param stepHelp The wizard page step help
	 */
	public void setStepHelp(String [] stepHelp) {
	    _stepHelp = stepHelp;
	}


	/**
	 *  @return The wizard page step help
	 */
	public String[] getStepHelp() {
	    return _stepHelp;
	}


	/**
	 *  @param cancelPrompt The wizard page cancel prompt
	 */
	public void setCancelPrompt(String cancelPrompt) {
	    _cancelPrompt = cancelPrompt;
	}


	/**
	 *  @return The wizard page cancel prompt
	 */
	public String getCancelPrompt() {
	    return _cancelPrompt;
	}


	/**
	 *  @param modelName    The wizard page model name used for the
	 *          ModelManager calls.  Defaults to
	 *          DescriptorCCWizardPage.WIZARD_MODEL
	 */
	public void setPageModelName(String modelName) {
	    if (modelName == null) {
		return;
	    }
	    _modelName = modelName;
	}


	/**
	 *  @return The page model name.
	 */
	public String getPageModelName() {
	    return _modelName;
	}


	/**
	 *  @param modelClass   The wizard page model class name to use during
	 *          ModelManager calls.  Defaults to
	 *          com.iplanet.jato.model.DefaultModel.
	 */
	public void setPageModelClass(String modelClass) {
	    if (modelClass == null) {
		return;
	    }
	    _modelClass = modelClass;
	}


	/**
	 *  @return The page model class.
	 */
	public String getPageModelClass() {
	    return _modelClass;
	}


	/**
	 *  @return The page model
	 */
	public Model getModel() {
	    try {
		// FIXME: Provide logging API
		// System.out.println("getPageModel("+getName()+") = ");
		return getRequestContext().getModelManager().getModel(
		    getPageModelClass(), getPageModelName(), true, true);
	    } catch (ClassNotFoundException ex) {
		throw new FrameworkException(
			"Unable to get to model for wizard '" + this.getName()
			+ "', page '" + getName() + "'.",
			ex, null, null);
	    }
	}

	/**
	 *  returns true is this is a results page
	 */
	public boolean isResultsPage() {
	    return _resultsPage;
	}

	public boolean isFinishPage() {
	    return _finishPage;
	}

	public void setPlaceHolderText(String text) {
	    if ((text == null) || (text.length() == 0)) {
		_placeHolderText = "Steps determined by choices";
	    } else {
		_placeHolderText = text;
	    }
	}

	public String getPlaceHolderText() {
	    return _placeHolderText;
	}

	public boolean isSubStep() {
	    return _subStep;
	}

	public boolean isBranchStep() {
	    return _branchStep;
	}

	public String toString() {
	    return _name;
	}
	/**
	 *  This value is set automatically.
	 */
	public static final String PAGE_NAME        = "pageName";

	/**
	 *  ViewDescriptor Parameter name ("cancelPrompt")
	 */
	public static final String CANCEL_PROMPT    = "cancelPrompt";

	/**
	 *  ViewDescriptor Parameter name ("stepHelp").  Note: this parameter
	 *  should be an array of String.
	 */
	public static final String STEP_HELP        = "stepHelp";

	/**
	 *  ViewDescriptor Parameter name ("stepInstructions")
	 */
	public static final String STEP_INSTRUCTIONS    = "stepInstructions";

	/**
	 *  ViewDescriptor Parameter name ("stepText")
	 */
	public static final String STEP_TEXT        = "stepText";

	/**
	 *  ViewDescriptor Parameter name ("wizardPageModelClass")
	 */
	public static final String PAGE_MODEL_CLASS = "wizardPageModelClass";

	/**
	 *  ViewDescriptor Parameter name ("wizardPageModelName")
	 */
	public static final String PAGE_MODEL_NAME  = "wizardPageModelName";

	/**
	 *  ViewDescriptor parameter name "resultsPage"
	 */
	public static final String RESULTS_PAGE = "resultsPage";

	/**
	 *  ViewDescriptor parameter name "finishPage"
	 *  If this is true the this is the finishPage
	 */
	public static final String FINISH_PAGE          = "finishPage";
	public static final String BRANCH_STEP          = "branchStep";
	public static final String SUB_STEP             = "subStep";
	public static final String PLACE_HOLDER_TEXT    = "placeHolderText";

	private String _cancelPrompt        = "";
	private String _name                = "";
	private String [] _stepHelp          = {""};
	private String _stepInstructions    = "";
	private String _stepText            = "";
	private String _modelClass          = "com.iplanet.jato.model.DefaultModel";
	private String _modelName           = DescriptorCCWizardPage.WIZARD_MODEL;
	private boolean _resultsPage        = false;
	private boolean _finishPage         = false;
	private boolean _subStep            = false;
	private String _placeHolderText     = null;
	private boolean _branchStep         = false;
    }


    /**
     *  This defines the parameter name for the resource bundle that should be
     *  set on the ViewDescriptor for this WizardImpl.  "resourceBundle"
     */
    public static final String RESOURCE_BUNDLE = "resourceBundle";

    /**
     *  This defines the parameter name for the wizard title that should be
     *  set on the ViewDescriptor for this WizardImpl.  "title"
     */
    public static final String WIZARD_TITLE = "title";


    /**
     *
     */
    public static final String WIZARD_WINDOW_PARAMETER_NAME =
	"WizardWindow." + CCWizardWindowModelInterface.WIZARD_NAME;

    private ViewDescriptor _viewDesc                =   null;
    private String _wizName                         =   null;
    private List _wizardPages                       =   new ArrayList();
    private boolean showResultsPage                 =   false;

    private String _resourceBundle                  =   "test.Resources";
    private String _title                           =   "WizardWindow";

    public static final String ERROR_MESSAGE        =   "errorMessage";
    public static final String SEVERITY             =   "severity";
    public static final String SHOW_STEPS           =   "showSteps";
}
