/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.ModelManager;

import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCAddRemoveModelInterface;

import com.sun.enterprise.tools.guiframework.view.DescriptorCCAddRemove;

/**
 *
 */
public class CCAddRemoveDescriptor extends ViewDescriptor {

    /**
     *	Constructor
     */
    public CCAddRemoveDescriptor(String name) {
	super(name);
    }


    /**
     *
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
// To create a CCAddRemoveModel:
// @param orientation     This orientation of Add/Remove
// @param showMoveButtons The flag indicating to show move up/down button
// @param listboxHeight   The listbox height
// @param listboxWidth    The listbox width
// @param availableList   The available listbox option list
// @param selectedList    The selected listbox option list
// @param label           The component label
// @param labelLocation   The label location
//
//    new CCAddRemoveModel(String orientation, String showMoveButtons,
//	    String listboxHeight, int listboxWidth, OptionList availableList,
//	    OptionList selectedList, String label, String labelLocation);
//
// We should support the above model constructor... these values can be
// passed in via "properties" (see ViewDescriptor.addProperty())

        return new DescriptorCCAddRemove(ctx, container, name, this, getModel());
    }
    

    public CCAddRemoveModelInterface getModel() {
	ModelManager mgr = RequestManager.getRequestContext().getModelManager();
        
        return (CCAddRemoveModelInterface)mgr.getModel(
                    CCAddRemoveModel.class,
                    getModelInstanceName(), 
                    shouldGetModelFromSession(),
                    shouldPutModelToSession());
    }
}
