/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.sun.web.ui.view.alert.CCAlertInline;


/**
 *
 */
public class CCAlertInlineDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCAlertInlineDescriptor(String name) {
	super(name);
    }


    /**
     *	<P>This is a factory method for CCAlertInline instances.  The following
     *	parameters are supported:</P>
     *
     *	<UL><LI>summary -- The Alert Summary</LI>
     *	    <LI>detail  -- The Alert Detail</LI>
     *	    <LI>type    -- The Alert type ("error", "help", "info",
     *		"warning")</LI></UL>
     *
     *	<P>See Lockhart Documenation for more details.</P>
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
    	// Create the alert, use "error" as default type
	CCAlertInline alert = new CCAlertInline(container, name, "error");

	// Set the bound name
	setBoundName(alert);

	// Figure out the alert type & create w/ that type
	Object value=getParameter(TYPE);
	if (value != null) {
	    alert.setValue(value);
	}

	// Set Summary if supplied
	value=getParameter(SUMMARY);
	if (value != null) {
	    alert.setSummary(value.toString());
	}

	// Set Detail if supplied
	value=getParameter(DETAIL);
	if (value != null) {
	    alert.setDetail(value.toString());
	}
	return alert;
    }


    /**
     *	This parameter ("summary") is used to supply the summary.
     */
    public static final String SUMMARY	= "summary";

    /**
     *	This parameter ("detail") is used to supply the detail.
     */
    public static final String DETAIL	= "detail";

    /**
     *	The parameter ("type") is used to set the Alert type.  Valid values
     *	are: "error", "help", "info", and "warning"  See
     *	com.sun.web.ui.view.alert.CCAlert.
     */
    public static final String TYPE	= "type";
}
