/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;

import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;

import com.sun.enterprise.tools.guiframework.view.DescriptorCCTabs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletRequest;


/**
 *
 *
 *  @author	Garrett Short, garrett.short@sun.com
 *  @author	Ken Paulsen, ken.paulsen@sun.com
 */
public class CCTabsDescriptor extends ViewDescriptor {

    /**
     *	Constructor
     */
    public CCTabsDescriptor(String name) {
	super(name);
    }


    /**
     *	Make sure the model is initialized.
     */
    public void registerChildren(ContainerViewBase instance) {
	getNodeTabsModel();
	super.registerChildren(instance);
    }


    /**
     *	This is a factory method for CCTabs instances.
     *
     *	@param	ctx	    The RequestContext
     *	@param	container   The container for the newly created 
     *  @param  name        The name of the component, must be the same name as in the JSP file
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	return new DescriptorCCTabs(ctx, container, name, this, getNodeTabsModel(ctx));
    }


    /**
     *	Builds the Tab model
     */
    public CCTabsModelInterface getNodeTabsModel() {
	return getNodeTabsModel(RequestManager.getRequestContext());
    }


    /**
     *
     */
    public CCTabsModelInterface getNodeTabsModel(RequestContext ctx) {
	// Get or create the model
        String pageName = getParent().getName();
	CCTabsModelInterface model = (CCTabsModelInterface)
	    ctx.getModelManager().getModel(
		CCTabsModelInterface.class, pageName+'.'+getName(), false, false);
	if (model.getNodes().size() > 0) {
	    // If there are some tabs already, this must be a cached model
	    return model;
	}
	// We have a new Model, let's set it up
	model.setIsLocal(true);
	ServletRequest request = ctx.getRequest();
        
        // There may be more than one tabs set registered. The ViewBeanMap 
        // needs to contain the map of all tabs. So add the enttries to any 
        // existing ViewBeanMap. However, only do this if the tabs set is for
        // the same page. Store the page name in the hash map so as to check.
        Map viewBeanMap = ((Map)request.getAttribute(VIEW_BEAN_MAP));
        int startCount = 1;
        if (viewBeanMap == null ||
                pageName.equals((String)viewBeanMap.get("pageName")) == false) {
            viewBeanMap = new HashMap();
            viewBeanMap.put("pageName", pageName);
            request.setAttribute(VIEW_BEAN_MAP, viewBeanMap);
        } else {
            startCount += viewBeanMap.size();
        }
	buildTabs(ctx, model, getChildDescriptors(), null, startCount);
	model.setSelectedNode(
	    ((Integer)request.getAttribute(CURR_TAB_ID)).intValue());
	return model;
    }

    
    /**
     *
     */
    protected int buildTabs(RequestContext ctx, CCTabsModelInterface model, List tabs, CCNavNodeInterface parent, int id) {
        if ((tabs == null) || (tabs.size() == 0)) {
            return id;
        }

        String currViewName = getParent().getName();

	// Add each Tab, and each tab's children
        for (int index=0; index<tabs.size(); index++) {
            ViewDescriptor tab = (ViewDescriptor)tabs.get(index);
            if (tab.getName().equals("TabHref")) {
                // "TabHref" is a Lockhart hard-code name. It is the name of the
                // hrefs used to construct the tabs component. A view Descriptor
                // may be defined for this href for processing events on the 
                // href itself. If this view descriptor is present, ignore it
                // in this tab processing.
                continue;
            }
            String label	= (String)tab.getParameter("label");
            String tooltip	= (String)tab.getParameter("tooltip");
            String status	= (String)tab.getParameter("status");
            String tabPage	= (String)tab.getParameter("nextPage");
            String target	= (String)tab.getParameter("target");
            if (label == null || tabPage == null) {
                throw new RuntimeException("Missing required parameters (label, nextPage) in tab declaration: "+
                    tab.getName()+", in view: "+currViewName, null);
            }
            CCNavNode node = new CCNavNode(id, parent, label, tooltip, status);
	    if ((target != null) && !(target.trim().equals(""))) {
		node.setTarget(target);
	    }
            if (parent == null) {
                model.addNode(node);
	    }
            if ((tabPage != null) && !(tabPage.equals(""))) {
		ServletRequest request = ctx.getRequest();
		((Map)request.getAttribute(VIEW_BEAN_MAP)).put(""+id, tabPage);
                if (tabPage.equals(currViewName)) {
		    request.setAttribute(CURR_TAB_ID, new Integer(id));
		}
            }
            id++;
            id = buildTabs(ctx, model, tab.getChildDescriptors(), node, id);
        }
        return id;
    }

    
    /**
     *	Returns the page name associated with the given tab id.
     */
    public String getViewBean(RequestContext ctx, int id) {
	Map vbMap = (Map)ctx.getRequest().getAttribute(VIEW_BEAN_MAP);
	if (vbMap == null) {
	    getNodeTabsModel(ctx);
	    vbMap = (Map)ctx.getRequest().getAttribute(VIEW_BEAN_MAP);
	}
        // Remove the ViewBeanMap once its referenced. It is only looked at once 
        // per web event during the submit cycle. Then during the display cycle,
        // the map needs to be recreated from scratch.
        ctx.getRequest().setAttribute(VIEW_BEAN_MAP, null);
	return vbMap.get(""+id).toString();
    }


    protected static final String VIEW_BEAN_MAP	= "__CCTabsDesc_VBs";
    protected static final String CURR_TAB_ID	= "__CCTabsDesc_parentID";
}
