/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BackupRequest.java
 *
 * Created on February 22, 2004, 1:40 AM
 */

package com.sun.enterprise.config.backup;

import java.io.*;
import java.util.*;

import com.sun.enterprise.config.backup.util.ObjectAnalyzer;
import com.sun.enterprise.config.backup.util.FileUtils;

/**
 * This class holds all of the values that the caller needs.  
 * An instance of this class can be used to create a request object.
 * @author  bnevins
 */

public class BackupRequest
{
	/**
	 * Create an instance
	 **/
	public BackupRequest(String domainsDirName, String domain, String desc)
	{
		setDomainsDir(domainsDirName);
		setDescription(desc);
		domainName	= domain;
	}
	
	/**
	 * Create an instance
	 **/
	public BackupRequest(String domainsDirName, String domain, String desc, String backupFileName)
	{
		this(domainsDirName, domain, desc);
		setBackupFile(backupFileName);
	}
	
	///////////////////////////////////////////////////////////////////////////

	public void setTerse(boolean b)
	{
		terse = b;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public void setVerbose(boolean b)
	{
		verbose = b;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public String toString()
	{
		return ObjectAnalyzer.toString(this);
	}
	
	///////////////////////////////////////////////////////////////////////////
	////////////     Private Methods     //////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	
	private void setDomainsDir(String name)
	{
		domainsDir	= FileUtils.safeGetCanonicalFile(new File(name));
	}

	///////////////////////////////////////////////////////////////////////////

	private void setBackupFile(String name)
	{
		backupFile	= FileUtils.safeGetCanonicalFile(new File(name));
	}

	///////////////////////////////////////////////////////////////////////////

	private void setDescription(String desc)
	{
		description = desc;
	}
	
	///////////////////////////////////////////////////////////////////////////
	////////////     Variables     ////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	
	final static String[] excludeDirs = {Constants.BACKUP_DIR + "/"}; 

	File	domainsDir;
	String	domainName;
	String	description;

	// VARIABLES POSSIBLY SET AT RUNTIME
	File	backupFile;
	
	// VARIABLES SET AT RUNTIME
	File	domainDir;
	long	timestamp;
	
	// variables used ONLY by ListManager
	// The reason it is here instead of in ListManager is so that
	// we can get a nice concise centralized display of ALL the variables
	// for all commands
	
	File	backupDir;
	boolean	terse	= false;
	boolean	verbose	= false;
}

