/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.util.*;
import java.io.*;
import java.util.*;

/**
 * Baseclass for BackupManager and RestoreManager.  Common code between the two goes
 * in here.
 * @author  Byron Nevins
 */

abstract class BackupRestoreManager
{
	public BackupRestoreManager(BackupRequest req) throws BackupException
	{
		if(req == null)
			throw new BackupException("backup-res.InternalError", getClass().getName() + ".ctor: null BackupRequest object");
		
		this.request = req;
		init();
		LoggerHelper.finest("Request DUMP **********\n" + req);
	}
	
	///////////////////////////////////////////////////////////////////////////////

	void init() throws BackupException
	{
		// only do once!
		if(wasInitialized)
			return;
		
		if(request == null)
			throw new BackupException("backup-res.InternalError", "null BackupRequest reference");
		
		// add a timestamp
		request.timestamp = System.currentTimeMillis();
		
		if(request.description == null || request.description.length() <= 0)
			request.description = "" + request.timestamp;
		// validate domains dir
		if(request.domainsDir == null || !FileUtils.safeIsDirectory(request.domainsDir))
			throw new BackupException("backup-res.NoDomainsDir", request.domainsDir);
		
		// validate the domain-name
		if(!StringUtils.ok(request.domainName))
			throw new BackupException("backup-res.InternalError", "No domain-name was specified");

		request.domainDir = new File(request.domainsDir, request.domainName);
		
		LoggerHelper.setLevel(request);
	}

	///////////////////////////////////////////////////////////////////////////
	
	BackupRequest		request;
	private boolean		wasInitialized = false;
}
