/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BackupRequestTest.java
 * JUnit based test
 *
 * Created on March 18, 2004, 1:23 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.*;
import com.sun.enterprise.util.io.FileUtils;
import java.io.*;
import junit.framework.*;

/**
 *
 * @author Byron Nevins
 */
public class BackupRequestTest extends TestCase
{
	
	public BackupRequestTest(java.lang.String testName)
	{
		super(testName);
	}
	
	public static Test suite()
	{
		TestSuite suite = new TestSuite(BackupRequestTest.class);
		return suite;
	}
	
	/** Test of verifyInfo method, of class com.sun.enterprise.config.backup.BackupRequest. */
	public void testBadCtor()
	{
		System.out.println("testVerifyInfo");
		try
		{
			BackupRequest req = new BackupRequest(null, null);
			BackupManager mgr = new BackupManager(req);
		}
		catch(NullPointerException e)
		{
			System.out.println(e);
			return;
		}
		catch(BackupException be)
		{
			System.out.println(be);
			return;
		}
		fail("Should have got an Exception!");
	}

	public void testBadDomainsDir()
	{
		System.out.println("testBadDomainsDir");
		try
		{
			BackupRequest req = new BackupRequest("w:/foo", "goo");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			return;
		}
		fail("Should have got an Exception!");
	}

	public void testGoodDomainsDir()
	{
		System.out.println("testGoodDomainsDir");
		File f = new File("c:/temp/goo");
		f.mkdirs();
		try
		{
			BackupRequest req = new BackupRequest("c:/temp", "goo");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			fail("Should not have got an Exception!");
		}
		finally
		{
			FileUtils.whack(f);
		}
	}
	public void testBadDomainName()
	{
		System.out.println("testBadDomainName");
		try
		{
			BackupRequest req = new BackupRequest("c:/temp", "");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			return;
		}
		fail("Should have got an Exception!");
	}
	public void testGoodDomainNameButNotExisting()
	{
		System.out.println("testGoodDomainName");
		try
		{
			File f = new File("c:/temp/goo");
			FileUtils.whack(f);
			BackupRequest req = new BackupRequest("c:/temp", "goo");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			return;
		}
		
		fail("Should have got an Exception!");
	}
	public void testGoodDomainName()
	{
		System.out.println("testGoodDomainName");
		File f = new File("c:/temp/goo");
		f.mkdirs();
		try
		{
			BackupRequest req = new BackupRequest("c:/temp", "goo");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			fail("Should not have got an Exception!");
		}
		finally
		{
			FileUtils.whack(f);
		}
	}

	public void testBadBackupFile()
	{
		System.out.println("testBadBackupFile");
		File f = new File("c:/temp/goo");
		try
		{
			f.mkdirs();
			BackupRequest req = new BackupRequest("c:/temp", "goo", "c:/temp/q.zip");
			BackupManager mgr = new BackupManager(req);
		}
		catch(BackupException be)
		{
			System.out.println(be);
			return;
		}
		finally
		{
			FileUtils.whack(f);
		}
		fail("Should have got an Exception!");
	}
	
	public static void main(java.lang.String[] args)
	{
		junit.textui.TestRunner.run(suite());
	}
}
