/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.Libraries;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;

import com.sun.enterprise.management.support.Delegate;

/**
    Base class for certain subclasses 
 */
public class DeployedItemConfigBase extends AMXConfigImplBase
    implements Libraries, ConfigFactoryCallback
{
		public
	DeployedItemConfigBase( final Delegate delegate )
	{
		super( delegate );
	}
	

        protected static String
	getPathSeparator()
	{
	    return System.getProperty( "path.separator" );
	}
	
	private static final String LIBRARIES_ATTR  = "Libraries";
	
	    public String[]
	getLibraries()
	{
	    final String s  = (String)delegateGetAttributeNoThrow( LIBRARIES_ATTR );
	    
	    final String[]  libraries = s == null ?
	        EMPTY_STRING_ARRAY : s.split( getPathSeparator() );
	        
	    return libraries;
	}
	
	/**
	    Note: some system apps make this Attribute read-only,
	    though the MBeanInfo advertises it as read/write.
	 */
	    public void
	setLibraries( final String[] libraries )
	{
	    if ( libraries == null || libraries.length == 0 )
	    {
	        final String[]  current = getLibraries();
	        if ( current.length == 0 )
	        {
	            // OK, no change
	        }
	        else
	        {
                delegateSetAttributeNoThrow( LIBRARIES_ATTR, null );
            }
	    }
	    else
	    {
    	    final String SEP    = getPathSeparator();
    	    
    	    for( final String s : libraries )
    	    {
    	        if ( s == null || s.length() == 0 || s.indexOf( SEP ) >= 0 )
    	        {
    	            throw new IllegalArgumentException( StringUtil.quote( "" + s ) );
    	        }
    	    }
    	    final String libs   = StringUtil.toString( SEP, (Object[])libraries );
            
            delegateSetAttributeNoThrow( LIBRARIES_ATTR, libs );
        }
	}
}







