/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/HealthCheckerConfigFactory.java,v 1.7 2006/03/09 20:30:38 llc Exp $
 * $Revision: 1.7 $
 * $Date: 2006/03/09 20:30:38 $
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Properties;
import java.util.Collections;

import static com.sun.appserv.management.base.XTypes.SERVER_REF_CONFIG;
import static com.sun.appserv.management.base.XTypes.CLUSTER_REF_CONFIG;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.GSetUtil;
import static com.sun.appserv.management.config.HealthCheckerConfigKeys.*;

final class HealthCheckerConfigFactory extends ConfigFactory {

    public HealthCheckerConfigFactory(final ConfigFactoryCallback callbacks) {
        super( callbacks );
    }

    private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
        GSetUtil.newUnmodifiableStringSet(
            URL_KEY,
            INTERVAL_IN_SECONDS_KEY,
            TIMEOUT_IN_SECONDS_KEY);

    protected Set<String> getLegalOptionalCreateKeys()  {
        return(LEGAL_OPTIONAL_KEYS);
    }

    protected ObjectName createOldChildConfig(final AttributeList translatedAttrs) {
        final String containerName = getFactoryContainer().getName();
        if (getFactoryContainer().getJ2EEType().equals(CLUSTER_REF_CONFIG)) {
            return getOldConfigProxies().getOldClusterRefMBean(
                containerName).createHealthChecker(translatedAttrs);
        } else if (getFactoryContainer().getJ2EEType().equals(SERVER_REF_CONFIG)) {
            return getOldConfigProxies().getOldServerRefMBean(
                containerName).createHealthChecker(translatedAttrs);
        }
        return null;
    }

    public ObjectName create(String url, String intervalInSeconds, String timeoutInSeconds)
    {
        Map<String,String> optional = new HashMap<String,String>();
        optional.put(URL_KEY, url);
        optional.put(INTERVAL_IN_SECONDS_KEY, intervalInSeconds);
        optional.put(TIMEOUT_IN_SECONDS_KEY, timeoutInSeconds);
        
        final Map<String,String> params = initParams(optional);
        final ObjectName amxName = createChild(params);
        return amxName;                
    }

    public void remove(String name) {
        final String containerName = getFactoryContainer().getName();
        if (getFactoryContainer().getJ2EEType().equals(CLUSTER_REF_CONFIG)) {
            getOldConfigProxies().getOldClusterRefMBean(containerName).removeHealthChecker();
        } else if (getFactoryContainer().getJ2EEType().equals(SERVER_REF_CONFIG)) {
            getOldConfigProxies().getOldServerRefMBean(containerName).removeHealthChecker();
        }
    }
}