/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Properties;

import javax.management.ObjectName;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;

/**
 */
public final class JACCProviderConfigFactory extends ConfigFactory
{
	private static final	String	POLICY_PROVIDER_KEY = "PolicyProvider";

	private static final	String	POLICY_CONFIGURATION_FACTORY_PROVIDER_KEY	= 
		"PolicyConfigurationFactoryProvider";
	
	private final OldSecurityServiceMBean	mOldSecurityService;
	
	/**

	 */
		public
	JACCProviderConfigFactory(final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
		
		mOldSecurityService	=
		    getOldConfigProxies().getOldSecurityServiceMBean( getConfigName() );
	}

	/**
		Create a new &lt;jacc-provider&gt;
		
		@param name			name of the &lt;jacc-provider>
		@param policyProvider		a classname
		@param policyConfigurationFactoryProvider	a classname
		@param reservedForFutureUse	reserved for future use
	 */
		public ObjectName	
	create(
        String	name,
        String	policyProvider,
        String	policyConfigurationFactoryProvider,
        Map<String,String> 	reservedForFutureUse )
	{
		final String[] requiredParams = {	
			POLICY_PROVIDER_KEY,					policyProvider,	
			POLICY_CONFIGURATION_FACTORY_PROVIDER_KEY,	policyConfigurationFactoryProvider,
		};
		
		if ( name == null )
		{
		    throw new IllegalArgumentException( "" + null );
		}

		final Map<String,String> params = initParams( name, requiredParams, reservedForFutureUse );

		final ObjectName amxName = createNamedChild( name, params );

		return amxName;
	}

		public void		
	removeByName( final String name )
	{
		mOldSecurityService.removeJaccProviderByName( name );
	}

	/**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		trace( "createOldChildConfig: attrs: " + stringify( translatedAttrs ) );
		
		final ObjectName	objectName	=
				mOldSecurityService.createJaccProvider( translatedAttrs );
		
		return( objectName );
	}
}




