/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
	Generated: Fri Jan 30 18:44:42 PST 2004
	Generated from:
	com.sun.appserv:type=module-log-levels,config=server-config,category=config
*/

package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
	
import com.sun.appserv.management.util.jmx.JMXUtil;


/**
	Configuration for the &lt;module-log-levels&gt; element.
*/

import com.sun.appserv.management.config.ModuleLogLevelsConfig;

public final class ModuleLogLevelsConfigImpl  extends AMXConfigImplBase
{
		public
	ModuleLogLevelsConfigImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
	private static final String[] MODULES	=
	{
		"Admin",
		"Classloader",
		"CMP",
		"Configuration",
		"Connector",
		"CORBA",
		"Deployment",
		"EJBContainer",
		"Javamail",
		"JAXR",
		"JAXRPC",
		"JDO",
		"JMS",
		"JTA",
		"JTS",
		"MDBContainer",
		"Naming",
		"ResourceAdapter",
		"Root",
		"SAAJ",
		"Security",
		"Server",
		"Verifier",
		"WebContainer",
		
		// 9.0 
		"Util",
		"Synchronization",
		"NodeAgent",
		"SelfManagement",
		"GroupManagementService",
	};
	
		public Map
	getAllLevels()
	{
		final AttributeList	attrs	= getAttributes( MODULES );
		
		assert ( attrs.size() == MODULES.length ) :
			"Missing some log levels, have: " + toString( attrs );
		
		return( JMXUtil.attributeListToValueMap( attrs ) );
	}
	
		public void
	changeAll( final String level )
	{
		final AttributeList	allAttrs	= new AttributeList();
		
		for( int i = 0; i < MODULES.length; ++i )
		{
			allAttrs.add( new Attribute( MODULES[ i ], level ) );
		}
		
		setAttributes( allAttrs );
	}

	

}